//=======================================================================================
//                 BTDLBT רҵBTںDLL
//                                  ʡĿʱ
//
//	Copyright:	Copyright (c) ޹˾
//  ȨУ	޹˾ (QQ:52401692   <support at dolit.cn>)
//
//              ǸΪҵĿʹãɡѵʹõBTں˿ʾ
//              Ҳڴյͽ飬ͬĽBT
//              ҵʹãôҪϵƷҵȨ
//              BTں˿ʾĴ⹫ں˿Ĵֻ޸ûʹá
//
//  ٷվ  http://www.dolit.cn      http://blog.dolit.cn
//
//=======================================================================================

#pragma once

#ifndef DOLIT_DLBT_LIB_DEF_H_
#define DOLIT_DLBT_LIB_DEF_H_

#ifdef	DLBT_EXPORT
#define DLBT_API extern "C"  __declspec(dllexport)
#pragma message("--- EXPORT DLBT Library  ...")
#else
#define DLBT_API extern "C"  __declspec(dllimport)
#pragma message("--- IMPORT DLBT Library  ...")
#endif


// ***************************  ںصĽӿ ********************************

//=======================================================================================
//  ں˵͹رպҵȨ˽Э鹦ܣʾֻñ׼BTʽ
//=======================================================================================

// ںʱĻǷDHTԼ˿ڵȣ
struct DLBT_KERNEL_START_PARAM
{
    BOOL bStartLocalDiscovery;		// ǷڵԶ֣ͨDHTTrackerֻҪһҲ֣ٶȿ죬Լȷͬһˣ
    BOOL bStartUPnP;				// ǷԶUPnPӳBTںĶ˿
    BOOL bStartDHT;					// ĬǷDHTĬϲԺýӿ
    BOOL bLanUser;                  // Ƿ񴿾ûϣûӺͨѶģʽ---ռֻͨûأ
    BOOL bVODMode;                  // ں˵ģʽǷϸVODģʽϸVODģʽʱһļķֿϸ񰴱Ƚ˳ķʽأǰأߴмĳ϶λ
                                    // ģʽȽʺϱر߲,ģʽ˺ܶŻڲأԲʺϴصķֻڱر߲ʱʹáĬͨģʽ
                                    // VODϰ汾Ч

    USHORT  startPort;	            // ں˼Ķ˿ڣstartPortendPortΪ0 startPort > endPort || endPort > 32765 ֲǷںһ˿ڡ startPortendPortϷ
    USHORT  endPort;				// ںԶstartPort ---- endPort֮һõĶ˿ڡ˿ڿԴDLBT_GetListenPort

    // ںڲĬãĬʹ˿ڣDHTȣ
    DLBT_KERNEL_START_PARAM ()
    {
        bStartLocalDiscovery = TRUE;
        bStartUPnP = TRUE;
        bStartDHT = TRUE;
        bLanUser = FALSE;
        bVODMode = FALSE;

        startPort = 0;
        endPort = 0;
    }
};

//=======================================================================================
//  þԶֵһЩ, interval_seconds鲥鲻Ҫ10s bUseBroadcast: Ƿʹù㲥ģʽ
//  Ĭڲʹ鲥ʹù㲥ܾ̫࣬һ㲻
//=======================================================================================
DLBT_API void WINAPI DLBT_SetLsdSetting (int interval_seconds, bool bUseBroadcast);

//=======================================================================================
//  ں˵͹رպҵȨ˽Э鹦ܣʾֻñ׼BTʽ
//=======================================================================================
DLBT_API BOOL WINAPI DLBT_Startup (
    DLBT_KERNEL_START_PARAM * param = NULL, // ںãοDLBT_KERNEL_START_PARAMΪNULLʹڲĬ
    LPCSTR  privateProtocolIDs = NULL,  // Զ˽Э飬ͻӪơΪNULLΪ׼BTͻ
                                        // BT˽Э3.4汾нȫ¸ĽԴ͸󲿷Ӫ̶Эķ
    bool    seedServerMode = false,     // ǷϴģʽϴģʽڲЩŻʺϴ󲢷ϴͨͻãֻϴʹ
                                        // רҵϴģʽҵЧʾݲָ֧ùܡʹ˵ĵ
    LPCSTR  productNum = NULL           // ҵûIDڹ߻ṩһƷԿҵ湦ܣðûʹNULL
    );

// ں˼Ķ˿
DLBT_API USHORT WINAPI DLBT_GetListenPort ();

// رյBTں
DLBT_API void WINAPI DLBT_Shutdown ();

// ڹرյٶȿܻȽ(Ҫ֪ͨTracker Stop), ԿԵøúǰ֪ͨ,ٶ
// Ȼڳ˳ʱDLBT_ShutdownȴĽ
DLBT_API void WINAPI DLBT_PreShutdown ();

//=======================================================================================
//  ں˵ϴٶȡû
//=======================================================================================
// ٶƣλֽ(BYTE)Ҫ1M 1024*1024
DLBT_API void WINAPI DLBT_SetUploadSpeedLimit (int limit);
DLBT_API void WINAPI DLBT_SetDownloadSpeedLimit (int limit);

// ӵ
DLBT_API void WINAPI DLBT_SetMaxUploadConnection (int limit);
DLBT_API void WINAPI DLBT_SetMaxTotalConnection (int limit);

// ෢ܶӿǷˣûϣ
DLBT_API void WINAPI DLBT_SetMaxHalfOpenConnection (int limit);

// ǷԸԼͬһû٣limitΪtrueʹúеֵ٣ޡĬϲͬһµûӦ١
DLBT_API void WINAPI DLBT_SetLocalNetworkLimit (
    bool    limit,              // Ƿþ
    int     downSpeedLimit,     // þ٣ٵĴСλֽ/
    int     uploadSpeedLimit    // þ٣ϴٶȴСλֽ/
    );

// ļɨУʱϢcircleCountѭٴһϢĬ0ҲǲϢ
// sleepMsϢãĬ1ms
DLBT_API void WINAPI DLBT_SetFileScanDelay (DWORD circleCount, DWORD sleepMs);

// ļɺǷ޸Ϊԭʼ޸ʱ䣨ʱÿļ޸ʱ״̬øútorrentлÿļʱ޸ʱϢ
// ûʱϢҵ˸úÿļʱԶļ޸ʱΪtorrentм¼ʱ
// ֻصĻ˸úӵĻûʹøúûÿļʱϢҲ޷ʱ޸
DLBT_API void WINAPI DLBT_UseServerModifyTime(BOOL bUseServerTime);

// ǷUDP͸书ܣĬԶӦԷ֧֣tcp޷ʱԶлΪudpͨѶ
DLBT_API void WINAPI DLBT_EnableUDPTransfer(BOOL bEnabled);

// ǷαװHttp䣬ĳЩǡһЩ磩Http٣P2P20Kң绷£Http
//  ĬαװHttpĴ루ԽǵͨѶԼӲαװ ͻȺûԿǶãαװ
// αװҲиãЩһͨHttpʹʹIPBTУԷûкϷᱻƽɱ
// ƣαװûٶȡʵʹѡ
DLBT_API void WINAPI DLBT_SetP2PTransferAsHttp (bool bHttpOut, bool bAllowedIn = true);

// ǷʹõĴ͸ʹõ͸Эĳ˫ϵĵp2pڵ㸨
DLBT_API BOOL WINAPI DLBT_AddHoleServer(LPCSTR ip, short port);

// ÷IPԶεöڱЩIPǷԱͳƴӷصݵϢٶȵһ̶ȿԶϿӣʡ
DLBT_API void WINAPI DLBT_AddServerIP (LPCSTR ip);
// ȥp2spurlظ. ĿǣǷϣp2spurlڱûҪȥurl
DLBT_API void WINAPI DLBT_AddBanServerUrl (LPCSTR url);

// һ״̬ļڲĬȫɺ󱣴һΡԵΪԼҪʱĿÿ5ӱһΣ100ݺ󱣴һ
DLBT_API BOOL WINAPI DLBT_SetStatusFileSavePeriod (
    int             iPeriod,               //λ롣Ĭ0ɣ
    int             iPieceCount            //ֿĿĬ0ɣ
    );

//=======================================================================================
//  ñTrackerıIPغ͹ʱԼNATĹIPȽЧϸο
//  BTʹ˵ĵ
//=======================================================================================
DLBT_API void WINAPI DLBT_SetReportIP (LPCSTR ip);
DLBT_API LPCSTR WINAPI DLBT_GetReportIP ();

DLBT_API void WINAPI DLBT_SetUserAgent (LPCSTR agent);

//=======================================================================================
//  ô̻棬3.3汾Ѷ⿪ţ3.3汾ϵͳڲԶ8M棬ʹø
//  еλKҪ1MĻ棬Ҫ1024
//=======================================================================================
DLBT_API void WINAPI DLBT_SetMaxCacheSize (DWORD size);

// һЩܲãĬ£BTΪͨ绷µϴãǧM
// Ҵã50M/s100M/sĵļٶȣҪЩԼڴ棬ҲЩ
// ý飬ѯȡ

DLBT_API void WINAPI DLBT_SetPerformanceFactor(
    int             socketRecvBufferSize,      // ĽջĬòϵͳĬϵĻС
    int             socketSendBufferSize,      // ķͻĬòϵͳĬϴС
    int             maxRecvDiskQueueSize,      // δд꣬󣬽ͣգȴݶСڸò
    int             maxSendDiskQueueSize       // Сڸò߳̽Ϊ͵ݣ󣬽̶ͣȡ
    );

//=======================================================================================
//  DHTغ,portDHTĶ˿ڣudp˿ڣΪ0ʹں˼TCP˿ںż
//=======================================================================================
DLBT_API void WINAPI DLBT_DHT_Start (USHORT port = 0);
DLBT_API void WINAPI DLBT_DHT_Stop ();
DLBT_API BOOL WINAPI DLBT_DHT_IsStarted ();

//=======================================================================================
//  ôغ,ҵȨд˹ܣʾݲṩ
//=======================================================================================

struct DLBT_PROXY_SETTING
{
    char    proxyHost [256];    // ַ
    int     nPort;              // Ķ˿
    char    proxyUser [256];    // Ҫ֤Ĵ,û
    char    proxyPass [256];    // Ҫ֤Ĵ,

    enum DLBT_PROXY_TYPE
    {
        DLBT_PROXY_NONE,            // ʹô
        DLBT_PROXY_SOCKS4,          // ʹSOCKS4Ҫû
        DLBT_PROXY_SOCKS5,          // ʹSOCKS5û
        DLBT_PROXY_SOCKS5A,         // ʹҪ֤SOCKS5Ҫû
        DLBT_PROXY_HTTP,            // ʹHTTPʣڱ׼HTTPʣTrackerHttpЭ鴫䣬򲻿
        DLBT_PROXY_HTTPA            // ʹҪ֤HTTP
    };

    DLBT_PROXY_TYPE proxyType;      // ָ
};


//=======================================================================================
//  ʶӦЩӣTrackerءDHThttpЭصȣ
//=======================================================================================
#define DLBT_PROXY_TO_TRACKER       1  // Trackerʹô
#define DLBT_PROXY_TO_DOWNLOAD      2  // ʱͬûPeerʹô
#define DLBT_PROXY_TO_DHT           4  // DHTͨѶʹôDHTʹudpͨѶҪ֧udp
#define DLBT_PROXY_TO_HTTP_DOWNLOAD 8  // HTTPʹôhttpЭʱЧTracker

// оʹô
#define DLBT_PROXY_TO_ALL   (DLBT_PROXY_TO_TRACKER | DLBT_PROXY_TO_DOWNLOAD | DLBT_PROXY_TO_DHT | DLBT_PROXY_TO_HTTP_DOWNLOAD)

DLBT_API void WINAPI DLBT_SetProxy (
    DLBT_PROXY_SETTING  proxySetting,   // ãIP˿ڵ
    int                 proxyTo         // ӦЩӣ궨ļͣDLBT_PROXY_TO_ALL
    );

//=======================================================================================
//  ȡãproxyToʶһӵĴϢproxyToֻܵȡĳ
//  ĴãʹDLBT_PROXY_TO_ALLֶѡ
//=======================================================================================
DLBT_API void WINAPI DLBT_GetProxySetting (DLBT_PROXY_SETTING * proxySetting, int proxyTo);

//=======================================================================================
//  üغ,Эַݾܣʵֱܴ䣬ڼBTЭͻ
//  󲿷Ӫ̵ķǰᵽ˽Э鲻ͬǣ˽ЭγԼ
//  P2P磬ͬBTͻ˼ݣ˽ЭȫBTЭˣûBTĺۼԴ͸
//  Ӫ̵ķͬ£ҪͬáαװHttpʹãĳЩЧ
//=======================================================================================
enum DLBT_ENCRYPT_OPTION
{
    DLBT_ENCRYPT_NONE,                  // ֧κμܵݣܵͨѶϿ
    DLBT_ENCRYPT_COMPATIBLE,            // ģʽԼӲʹüܣ˵ļӽ룬ܵͬԷüģʽỰ
    DLBT_ENCRYPT_FULL,                  // ܣԼĬʹüܣͬʱͨͼܵ롣üģʽỰǼģʽỰ
                                        // Ĭ
    DLBT_ENCRYPT_FORCED,                // ǿƼܣּ֧ͨѶͨӣܵϿ
};

// ܲ㼶ߣϻ˷һCPUݴ䰲ȫͻƷ
enum DLBT_ENCRYPT_LEVEL
{
    DLBT_ENCRYPT_PROTOCOL,          // BTͨѶЭ  һڷֹӪ̵ֹ
    DLBT_ENCRYPT_DATA,              // ݣ ڱǿļ
    DLBT_ENCRYPT_PROTOCOL_MIX,      // ʹüЭģʽԷʹݼܣҲ֧ͬʹݼģʽͨѶ
    DLBT_ENCRYPT_ALL                // Эݾ
};

// ڲĬʹüԼܣЭݾݼܣû󣬽鲻Ҫ
DLBT_API void WINAPI DLBT_SetEncryptSetting (
    DLBT_ENCRYPT_OPTION     encryptOption,      // ѡͻ߲
    DLBT_ENCRYPT_LEVEL      encryptLevel        // ܵĳ̶ȣݻЭܣ
    );

// ***************************  ǵصĽӿ ********************************

// ص״̬
enum DLBT_DOWNLOAD_STATE
{
	BTDS_QUEUED,	                // 
	BTDS_CHECKING_FILES,	        // ڼУļ
	BTDS_DOWNLOADING_TORRENT,	    // ģʽ£ڻȡӵϢ
	BTDS_DOWNLOADING,	            // 
    BTDS_PAUSED,                    // ͣ
	BTDS_FINISHED,	                // ָļ
	BTDS_SEEDING,	                // Уеļɣ
	BTDS_ALLOCATING,                // Ԥ̿ռ -- Ԥռ䣬ٴƬ
                                    // ѡйأʱѡԤ̷ʽܽ״̬
    BTDS_ERROR,                     // д̳ԭϸԭͨDLBT_Downloader_GetLastError֪
};

// ļķģʽ,ʹ˵ĵ
enum DLBT_FILE_ALLOCATE_TYPE
{
    FILE_ALLOCATE_REVERSED  = 0,   // Ԥģʽ,Ԥȴļ,ÿһŵȷλ
    FILE_ALLOCATE_SPARSE,          // Default mode, more effient and less disk space.NTFSЧ http://msdn.microsoft.com/en-us/library/aa365564(VS.85).aspx
    FILE_ALLOCATE_COMPACT          // ļСز,ÿһݰһ,ǵλ,вϵλ,ļλ÷ȷ         .
};

// ***************************  ¼һBTصĺ ********************************
//=======================================================================================
//  һļأصľԺԸвҪݾ
//=======================================================================================
DLBT_API HANDLE WINAPI DLBT_Downloader_Initialize (
        LPCWSTR             torrentFile,                    // ļ·嵽ļ
        LPCWSTR             outPath,                        // غı·ֻĿ¼
        LPCWSTR             statusFile = L"",           // ״̬ļ·
        DLBT_FILE_ALLOCATE_TYPE  fileAllocateType = FILE_ALLOCATE_SPARSE,         // ļģʽ
        BOOL                bPaused = FALSE,                // Ƿ񣬴򿪾ͣ
        BOOL                bQuickSeed = FALSE,             // Ƿٹ֣ҵṩ
        LPCSTR              password = NULL,                // ǷӣΪNullͨӣӵ룬ð治֧֣òᱻ
        LPCWSTR             rootPathName = NULL,             // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                            // ԵļֱӽиΪָ
        BOOL                bPrivateProtocol = FALSE,        // Ƿ˽Э飨ԶԲͬӲòͬطʽ
		BOOL				bZipTransfer = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
        );

// һڴеļݣļǶ洢߰ĳܷʽӵԽܺݴBTں
DLBT_API HANDLE WINAPI DLBT_Downloader_Initialize_FromBuffer (
        LPBYTE              torrentFile,                    // ڴеļ
        DWORD               dwTorrentFileSize,              // ݵĴС
        LPCWSTR             outPath,                        // غı·ֻĿ¼
        LPCWSTR             statusFile = L"",              // ״̬ļ·
        DLBT_FILE_ALLOCATE_TYPE  fileAllocateType = FILE_ALLOCATE_SPARSE,         // ļģʽ
        BOOL                bPaused = FALSE,
        BOOL                bQuickSeed = FALSE,             // Ƿٹ֣ҵṩ
        LPCSTR              password = NULL,                // ǷӣΪNullͨӣӵ룬ð治֧֣òᱻ
        LPCWSTR             rootPathName = NULL,             // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                            // ԵļֱӽиΪָ
        BOOL                bPrivateProtocol = FALSE,
		BOOL				bZipTransfer = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
        );

// һTorrentһ
DLBT_API HANDLE WINAPI DLBT_Downloader_Initialize_FromTorrentHandle (
        HANDLE              torrentHandle,                    // Torrent
        LPCWSTR             outPath,                        // غı·ֻĿ¼
        LPCWSTR             statusFile = L"",              // ״̬ļ·
        DLBT_FILE_ALLOCATE_TYPE  fileAllocateType = FILE_ALLOCATE_SPARSE,         // ļģʽ
        BOOL                bPaused = FALSE,
        BOOL                bQuickSeed = FALSE,              // Ƿٹ֣ҵṩ
        LPCWSTR             rootPathName = NULL,             // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                            // ԵļֱӽиΪָ
        BOOL                bPrivateProtocol = FALSE,
		BOOL				bZipTransfer = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
    );

//ģʽðЧԵЩӿڣЧ
DLBT_API HANDLE WINAPI DLBT_Downloader_Initialize_FromInfoHash (
        LPCSTR              trackerURL,                     // trackerĵַ
        LPCSTR              infoHash,                       // ļinfoHashֵ
        LPCWSTR             outPath,
        LPCWSTR             name = NULL,                    // ص֮ǰûа취ֵ֪ģ˿Դһʱ
        LPCWSTR             statusFile = L"",              // ״̬ļ·
        DLBT_FILE_ALLOCATE_TYPE  fileAllocateType = FILE_ALLOCATE_SPARSE,         // ļģʽ
        BOOL                bPaused = FALSE,
        LPCWSTR             rootPathName = NULL,            // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                            // ԵļֱӽиΪָ
        BOOL                bPrivateProtocol = FALSE,
		BOOL				bZipTransfer = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
        );

// ģʽһӿڣֱַͨأַʽΪ DLBT://xt=urn:btih: Base32 info-hash [ &dn= Base32 ] [ &tr= Base32trackerĵַ ]  ([]Ϊѡ)
// ȫѭuTorrentĹٷBTչЭ
DLBT_API HANDLE WINAPI DLBT_Downloader_Initialize_FromUrl (
    LPCSTR              url,                            // ַ
    LPCWSTR             outPath,                        // Ŀ¼
    LPCWSTR             statusFile = L"",              // ״̬ļ·
    DLBT_FILE_ALLOCATE_TYPE  fileAllocateType = FILE_ALLOCATE_SPARSE,
    BOOL                bPaused = FALSE,
    LPCWSTR             rootPathName = NULL,            // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                        // ԵļֱӽиΪָ
    BOOL                bPrivateProtocol = FALSE,
	BOOL				bZipTransfer = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
    );

// רҵļ½ӿڣļΪļļ仯ݿ顣ҵṩ
DLBT_API HANDLE WINAPI DLBT_Downloader_InitializeAsUpdater (
    LPCWSTR             curTorrentFile,    //ǰ汾ļ
    LPCWSTR             newTorrentFile,   //  °ļ
 	LPCWSTR             curPath,    //  ǰļ·
    LPCWSTR             statusFile = L"", // ״̬ļ·
 	DLBT_FILE_ALLOCATE_TYPE    type = FILE_ALLOCATE_SPARSE, //  ļ䷽ʽ͵ǰ汾һ£°汾Ҳʹø÷䷽ʽ
 	BOOL                bPaused = FALSE,     // Ƿͣʽ
  	LPCSTR              curTorrentPassword = NULL,   // ǰ汾ӵ루˲Ҫ룩
 	LPCSTR              newTorrentFilePassword = NULL, //ӵ
 	LPCWSTR             rootPathName = NULL,
	BOOL				bPrivateProtocol = FALSE,
	float		*       fProgress = NULL,         //ΪNULL򴫳DLBT_Downloader_GetOldTorrentProgressһһ
	BOOL				bZipTransfer = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
);

// רҵļʱӣȻֱӴӺӵĲȣ99%ζֻ1%Ҫء
DLBT_API float WINAPI DLBT_Downloader_GetOldTorrentProgress (
	LPCWSTR             curTorrentFile,    //ǰ汾ļ
	LPCWSTR             newTorrentFile,   //  °ļ
	LPCWSTR             curPath,    //  ǰļ·
	LPCWSTR             statusFile = L"", // ״̬ļ·
	LPCSTR              curTorrentPassword = NULL,
	LPCSTR              newTorrentFilePassword = NULL
	);

//-------------------------------------------------------------------------------------------------------------------------------
// ر֮ǰԵøúͣIO̶߳ԸĲ첽ģҪDLBT_Downloader_IsReleasingFilesȡǷͷУ
// úúֱӵ_ReleaseɶԸþٵDLBT_DwonloaderڲͣأȻͷŵļ
DLBT_API void WINAPI DLBT_Downloader_ReleaseAllFiles(HANDLE hDownloader);
// ǷͷžĹ
DLBT_API BOOL WINAPI DLBT_Downloader_IsReleasingFiles(HANDLE hDownloader);

enum DLBT_RELEASE_FLAG
{
    DLBT_RELEASE_NO_WAIT = 0,           // ĬϷʽReleaseֱͷţȴͷ
    DLBT_RELEASE_WAIT = 1,              // ȴļͷ
    DLBT_RELEASE_DELETE_STATUS = 2,     // ɾ״̬ļ
    DLBT_RELEASE_DELETE_ALL = 4         // ɾļ
};

// رhDownloaderǵ nFlag οDLBT_RELEASE_FLAG
DLBT_API HRESULT WINAPI DLBT_Downloader_Release (HANDLE hDownloader, int nFlag = DLBT_RELEASE_NO_WAIT);

// һhttpĵַļĳWebhttpʱʹãwebı뷽ʽΪUTF-8ʽϵ޸
DLBT_API void WINAPI DLBT_Downloader_AddHttpDownload (HANDLE hDownloader, LPSTR url);
// ƳһP2SPĵַУжϿҴӺѡбƳٽ
DLBT_API void WINAPI DLBT_Downloader_RemoveHttpDownload (HANDLE hDownloader, LPSTR url);
// һHttpַԽٸӣĬ1. ܺãã10ǶһHttpַԽ10ӡ
// ֮ǰѾһHttpַ˶ӣٶϿú½ʱЧ
DLBT_API void WINAPI DLBT_Downloader_SetMaxSessionPerHttp (HANDLE hDownloader, int limit);

// P2SPʱҪչǷһԼļ·ı
//չڷֹһЩӪ̶httpڻ棬Եصǻϰ汾ļԿʹһ.phpչֹû
//Ҫý.php׺ԣļͨnginxrewriteȹʵ
//Ƿһ?a=bֲҲǷֹģǶӪ̶Ч
//bUtf8Ƿʹutf8·룬ĬtruefalseЩ·ȡ
// úΪȫֵģĳ
DLBT_API void WINAPI DLBT_SetP2SPExtName (LPCSTR extName, bool bUseRandParam, bool bUtf8);


// ȡеHttpӣڴDLBT_Downloader_FreeConnectionsͷ
DLBT_API void WINAPI DLBT_Downloader_GetHttpConnections(HANDLE hDownloader, LPSTR ** urls, int * urlCount);
// ͷDLBT_Downloader_GetHttpConnectionsڴ
DLBT_API void WINAPI DLBT_Downloader_FreeConnections(LPSTR * urls, int urlCount);

DLBT_API void WINAPI DLBT_Downloader_AddTracker (HANDLE hDownloader, LPCSTR url, int tier);
DLBT_API void WINAPI DLBT_Downloader_RemoveAllTracker (HANDLE hDownloader);
DLBT_API void WINAPI DLBT_Downloader_AddHttpTrackerExtraParams (HANDLE hDownloader, LPCSTR extraParams);

// Ƿ˳,ĬǷ˳(,һѭϡ,ַʽٶȿ),˳ڱ±߲
DLBT_API void WINAPI DLBT_Downloader_SetDownloadSequence (HANDLE hDownloader, BOOL ifSeq = FALSE);

// ص״̬ Լ ͣͼĽӿ
DLBT_API DLBT_DOWNLOAD_STATE WINAPI DLBT_Downloader_GetState (HANDLE hDownloader);
DLBT_API BOOL WINAPI DLBT_Downloader_IsPaused (HANDLE hDownloader);
DLBT_API void WINAPI DLBT_Downloader_Pause (HANDLE hDownloader);        //ͣ
DLBT_API void WINAPI DLBT_Downloader_Resume (HANDLE hDownloader);       //
//״̬µӿ һֻڼļ޷дʱŻˣ
//״̬ΪBTDS_ERRORͨýӿڻȡϸϢ
DLBT_API HRESULT WINAPI DLBT_Downloader_GetLastError (
    HANDLE  hDownloader,  // 
    LPSTR   pBuffer,      // ڷϢڴ棬ΪգΪpBufferSizeзֵʵʴС
    int *   pBufferSize  // bufferڴСֵʵʴС
    );

DLBT_API void WINAPI DLBT_Downloader_ResumeInError (HANDLE hDownloader); //󣬳¿ʼ

// صؽӿڣģʽðЧԵЩӿڣЧ
DLBT_API BOOL WINAPI DLBT_Downloader_IsHaveTorrentInfo (HANDLE hDownloader); // ʱжǷɹȡϢ
DLBT_API HRESULT WINAPI DLBT_Downloader_MakeURL (  // ͨӣһԲҪӼصַοDLBT_Downloader_Initialize_FromUrl
    HANDLE      hDownloader,
    LPSTR       pBuffer,                // ڷϢڴ棬ΪգΪpBufferSizeзֵʵʴС
    int  *      pBufferSize             // bufferڴСURLʵʴС
    );
// أѾصӣӱԺʹ
DLBT_API HRESULT WINAPI DLBT_Downloader_SaveTorrentFile (HANDLE hDownloader, LPCWSTR filePath, LPCSTR password = NULL);

// صٺӵĽӿ
DLBT_API void WINAPI DLBT_Downloader_SetDownloadLimit (HANDLE hDownloader, int limit);
DLBT_API void WINAPI DLBT_Downloader_SetUploadLimit (HANDLE hDownloader, int limit);
DLBT_API void WINAPI DLBT_Downloader_SetMaxUploadConnections (HANDLE hDownloader, int limit);
DLBT_API void WINAPI DLBT_Downloader_SetMaxTotalConnections (HANDLE hDownloader, int limit);

// ȷֻϴ
DLBT_API void WINAPI DLBT_Downloader_SetOnlyUpload (HANDLE hDownloader, bool bUpload);

// öԷIP٣λBYTE(ֽڣҪ1M1024*1024
DLBT_API void WINAPI DLBT_Downloader_SetServerDownloadLimit(HANDLE hDownloader, int limit);
// ñȥеķIPӣڶԷӣҪBTЭ֪ͨǶӦhDownloaderĺٶϿ
DLBT_API void WINAPI DLBT_Downloader_BanServerDownload(HANDLE hDownloader, bool bBan);

// ط (ϴ/صıĽӿ
DLBT_API void WINAPI DLBT_Downloader_SetShareRateLimit (HANDLE hDownloader, float fRate);
DLBT_API double WINAPI DLBT_Downloader_GetShareRate (HANDLE hDownloader);

// صļԣļСȵȣ
DLBT_API HRESULT WINAPI DLBT_Downloader_GetTorrentName (
    HANDLE      hDownloader,
    LPWSTR      pBuffer,        // ڷϢڴ棬ΪգΪpBufferSizeзֵʵʴС
    int     *   pBufferSize     // bufferڴСֵʵʴС
    );
DLBT_API UINT64 WINAPI DLBT_Downloader_GetTotalFileSize (HANDLE hDownloader);
DLBT_API UINT64 WINAPI DLBT_Downloader_GetTotalWanted (HANDLE hDownloader);     // ѡ˶صļ
DLBT_API UINT64 WINAPI DLBT_Downloader_GetTotalWantedDone (HANDLE hDownloader); // ѡļУ˶
DLBT_API float WINAPI DLBT_Downloader_GetProgress (HANDLE hDownloader);

DLBT_API UINT64 WINAPI DLBT_Downloader_GetDownloadedBytes (HANDLE hDownloader);
DLBT_API UINT64 WINAPI DLBT_Downloader_GetUploadedBytes (HANDLE hDownloader);
DLBT_API UINT WINAPI DLBT_Downloader_GetDownloadSpeed (HANDLE hDownloader);
DLBT_API UINT WINAPI DLBT_Downloader_GetUploadSpeed (HANDLE hDownloader);

// øĽڵĿĿĲΪintָ룬ҪĳֵNULL
DLBT_API void WINAPI DLBT_Downloader_GetPeerNums (
    HANDLE      hDownloader,        // ľ
    int     *   connectedCount,     // ϵĽڵû
    int     *   totalSeedCount,     // ܵĿTracker֧scrap򷵻-1
    int     *   seedsConnected,     // Լϵ
    int     *   inCompleteCount,    // δTracker֧scrap򷵻-1
    int     *   totalCurrentSeedCount, // ǰߵܵɵϵĺδϵģ
    int     *   totalCurrentPeerCount  // ǰߵܵصϵĺδϵģ
    );

// аļʱһЩӿ,indexΪļкţ0ʼ
DLBT_API int WINAPI DLBT_Downloader_GetFileCount (HANDLE hDownloader);
DLBT_API UINT64 WINAPI DLBT_Downloader_GetFileSize (HANDLE hDownloader, int index);
// ȡļtorrentеʼλ
DLBT_API UINT64 WINAPI DLBT_Downloader_GetFileOffset (HANDLE hDownloader, int index);
DLBT_API BOOL WINAPI DLBT_Downloader_IsPadFile (HANDLE hDownloader, int index);
DLBT_API HRESULT WINAPI DLBT_Downloader_GetFilePathName (
    HANDLE      hDownloader,        // ľ
    int         index,              // ļ
    LPWSTR      pBuffer,            // ļ
    int     *   pBufferSize,        // bufferĴСļʵʳ
    bool        needFullPath = false// ǷҪȫ·ֻҪļе·
    );

// úὫĿ¼´ڣtorrent¼вڵļȫɾԵļЧʹá
DLBT_API HRESULT WINAPI DLBT_Downloader_DeleteUnRelatedFiles (HANDLE hDownloader);

// ȡÿļHashֵֻʱʹbUpdateExtܻȡ
DLBT_API HRESULT WINAPI DLBT_Downloader_GetFileHash (
	HANDLE      hDownloader,        // ľ
	int         index,              // ҪȡļţpieceĿͨDLBT_Downloader_GetFileCount
	LPSTR       pBuffer,            // Hashַ
	int     *   pBufferSize         // pBufferĴСpieceInfoHash̶Ϊ20ֽڣ˴˴Ӧ20ĳȡ
	);

// ȡļؽȣòҪн϶ڱҪʱʹ
DLBT_API float WINAPI DLBT_Downloader_GetFileProgress (HANDLE hDownloader, int index);

enum DLBT_FILE_PRIORITIZE
{
    DLBT_FILE_PRIORITY_CANCEL        =   0,     // ȡļ
    DLBT_FILE_PRIORITY_NORMAL,                  // ȼ
    DLBT_FILE_PRIORITY_ABOVE_NORMAL,            // ȼ
    DLBT_FILE_PRIORITY_MAX                      // ȼиȼļδ꣬صȼļ
};

// ļȼȡĳָļ,indexʾļ
DLBT_API HRESULT WINAPI DLBT_Downloader_SetFilePrioritize (
    HANDLE                  hDownloader,
    int                     index,              // ļ
    DLBT_FILE_PRIORITIZE    prioritize,         // ȼ
    BOOL                    bDoPriority = TRUE  // ǷӦãжļҪãʱӦãһļӦ
                                                // ߿DLBT_Downloader_ApplyPrioritizeӦãΪÿӦһöҪPiece
                                                // һ飬Ƚ鷳ӦһӦ
    );

// Ӧȼ
DLBT_API void WINAPI DLBT_Downloader_ApplyPrioritize (HANDLE hDownloader);

// ȡǰÿֿ״̬жǷҪȥ£ǷѾӵ˸ÿ飩
DLBT_API HRESULT WINAPI DLBT_Downloader_GetPiecesStatus (
    HANDLE                  hDownloader,    // 
    bool                *   pieceArray,     // ÿǷ񱾵µ
    int                     arrayLength,    // ĳ
    int                 *   pieceDownloaded // ѾصķֿĿʾصķֿͼʱòȽáָֺϴλȡʱû
                                            // 仯ԲҪػǰķֿ״̬ͼ
    );

// Pieceֿ飩ȼȡĳЩֿأָλÿʼصȡindexʾֿ
DLBT_API HRESULT WINAPI DLBT_Downloader_SetPiecePrioritize (
    HANDLE                  hDownloader,
    int                     index,              // 
    DLBT_FILE_PRIORITIZE    prioritize,         // ȼ
    BOOL                    bDoPriority = TRUE  // ǷӦãжֿҪãʱӦãһӦ
                                                // ߿DLBT_Downloader_ApplyPrioritizeӦãΪÿӦһöҪPiece
                                                // һ飬Ƚ鷳ӦһӦ
    );

// ָֹPeerϢ
DLBT_API void WINAPI DLBT_Downloader_AddPeerSource (HANDLE hDownloader, char * ip, USHORT port);


// ÿʾļHashֵ
DLBT_API HRESULT WINAPI DLBT_Downloader_GetInfoHash (
    HANDLE      hDownloader,        // ľ
    LPSTR       pBuffer,            // InfoHashڴ滺
    int     *   pBufferSize         // 뻺ĴСʵʵInfoHashĳ
    );

DLBT_API int WINAPI DLBT_Downloader_GetPieceCount (HANDLE hDownloader);
DLBT_API int WINAPI DLBT_Downloader_GetPieceSize (HANDLE hDownloader);

// һ״̬ļ֪ͨڲ̺߳أ첽ܻһӳٲŻд
DLBT_API void WINAPI DLBT_Downloader_SaveStatusFile (HANDLE hDownloader);

//bOnlyPieceStatus ǷֻһЩļֿϢڷɺ󷢸ÿͻͻͲٱȽˣֱӿ. ĬFALSEҲȫϢ
DLBT_API void WINAPI DLBT_Downloader_SetStatusFileMode (HANDLE hDownloader, BOOL bOnlyPieceStatus);

// 鿴״̬ļǷ
DLBT_API BOOL WINAPI DLBT_Downloader_IsSavingStatus (HANDLE hDownloader);

// BTϵͳдͨʽݿ顣offsetΪݿļļУеƫsizeΪݿСdataΪݻ
// ɹS_OKʧΪʧԭǸÿ鲻Ҫٴδˡ VODǿЧ
DLBT_API HRESULT WINAPI DLBT_Downloader_AddPartPieceData(HANDLE hDownloader, UINT64 offset, UINT64 size, char *data);

// ֹһݽ VODǿЧ
DLBT_API HRESULT WINAPI DLBT_Downloader_AddPieceData(
    HANDLE                  hDownloader,
    int                     piece,          //ֿ
    char            *       data,           //ݱ
    bool                    bOverWrite      //ѾˣǷ񸲸
    );


// ÿҪ滻һݿʱһصⲿԸصʾ滻ĽȣԼǷֹ滻൱ڣDLBT_Downloader_CancelReplace)
// FALSEϣֹTRUE
// һֿܻСļߴļβļճĵطһֿpieceIndexܻӦ˶ļƬΡص滻һļƬʱһ
typedef BOOL (WINAPI * DLBT_REPLACE_PROGRESS_CALLBACK) (
      IN void * pContext,                   // صģͨDLBT_Downloader_ReplacePieceDatapContext룩ﴫȥ洦
                                            // 磬ⲿһthisָ룬صʱָ֪ͨǶӦĸ
      IN int pieceIndex,                    //Ҫ滻λĸֿ飨ֿtorrentе
      IN int replacedPieceCount,            //Ѿ˶ٸpiece滻
      IN int totalNeedReplacePieceCount,    //ܹжٸҪ滻pieceֿ
      IN int fileIndex,                     //Ҫ滻λĸļ
      IN UINT64 offset,                     //ļУݵƫ
      IN UINT64 size,                       //ݵܴСƫ
      IN int replacedFileSliceCount,        //Ѿ˶ٸļƬε滻
      IN int totalFileSliceCount            //ܹжٸҪ滻ļƬ
      );

// 滻ݿĽӿڣĳֱ滻ĿļͬλãһڣʱҪصķֿԶصһʱĿ¼ɺ滻ԭʼļ
// عԭʼļʹãֻزݵŵ㡣
// úأHRESULTصĲS_OK˵Ҫ鿴ֵ
// S_OKڲ߳滻мĽʱͨDLBT_Downloader_GetReplaceResultв鿴ʱԵãDLBT_Downloader_CancelReplaceȡ̲߳
DLBT_API HRESULT WINAPI DLBT_Downloader_ReplacePieceData(
	HANDLE			hDownloader,		//
	int   *			pieceArray,			// ҪЩֿ滻һint
	int				arrayLength,		// ֿĳ
	LPCWSTR			destFilePath,		// Ҫ滻ļļУĿ¼磺E:\Test\1.rarE:\Test\Game\˲ ȡ
	LPCWSTR			tempRootPathName = NULL,	// ʱĿ¼ʱʹrootPathNameҲҪϣԱļļУ¶ȡݿ
	LPCWSTR			destRootPathName = NULL,	// Ҫ滻ǸʹrootPathNameҲҪϣԱļļУ滻
    LPVOID          pContext = NULL,
    DLBT_REPLACE_PROGRESS_CALLBACK  callback = NULL  //սȣʱȡĻص
	);

// ReplacePieceDataһЩ״̬ͨDLBT_Downloader_GetReplaceResultв鿴
enum DLBT_REPLACE_RESULT
{
    DLBT_RPL_IDLE  = 0,     //δʼ滻
    DLBT_RPL_RUNNING,       //
    DLBT_RPL_SUCCESS,       //滻ɹ
    DLBT_RPL_USER_CANCELED, //滻һ룬ûȡ
    DLBT_RPL_ERROR,         //ͨhrDetailȡϸϢοDLBT_Downloader_GetReplaceResult
};

// ȡ滻ݵĽ
DLBT_API DLBT_REPLACE_RESULT WINAPI DLBT_Downloader_GetReplaceResult(
    HANDLE          hDownloader,        //
    HRESULT  *      hrDetail,           //гϸĳԭ
    BOOL     *      bThreadRunning      //ReplaceǷˣҲģ
    );

// мʱȡ滻ݵĲȡΪпܻ滻һ룬Щļǲģ
DLBT_API void WINAPI DLBT_Downloader_CancelReplace(HANDLE hDownloader);

//////////////////////   Moveؽӿ   /////////////
// MoveĽ
enum DOWNLOADER_MOVE_RESULT
{
	DLBT_MOVED	= 0,	//ƶɹ
	DLBT_MOVE_FAILED,	//ƶʧ
	DLBT_MOVING         //ƶ
};

//ƶĸĿ¼ͬһ̷ǼУǲͬǸƺɾԭʼļڲ첽
//ʹDLBT_Downloader_GetMoveResultȥȡ
DLBT_API void WINAPI DLBT_Downloader_Move (HANDLE hDownloader, LPCWSTR savePath);
//鿴ƶĽ
DLBT_API DOWNLOADER_MOVE_RESULT WINAPI DLBT_Downloader_GetMoveResult (
	HANDLE			hDownloader,   // ľ
	LPSTR			errorMsg,      // ڷسϢڴ棬DLBT_MOVE_FAILED״̬ﷵس顣NULL򲻷شϢ
	int				msgSize		   // ϢڴĴС
	);


// ***************************  صĽӿ ********************************

enum DLBT_TORRENT_TYPE
{
    USE_PUBLIC_DHT_NODE     = 0,    // ʹùDHTԴ
    NO_USE_PUBLIC_DHT_NODE,         // ʹùDHTڵ
    ONLY_USE_TRACKER,               // ʹTrackerֹDHTûԴ˽ӣ
};

// һTorrentľڴӵľ
DLBT_API HANDLE WINAPI DLBT_CreateTorrent (
    int             pieceSize,      // ļķֿСλֽڣ0ںԶȷ
    LPCWSTR         file,           // ļĿ¼Ŀ¼Ŀ¼ļһӣ
    LPCWSTR         publisher = NULL,   // Ϣ
    LPCWSTR         publisherUrl = NULL, // ߵַ
    LPCWSTR         comment = NULL,  // ۺ
    DLBT_TORRENT_TYPE torrentType = USE_PUBLIC_DHT_NODE,   // ӵ
    int       *     nPercent = NULL,  // ӵĽ
    BOOL      *     bCancel = NULL,   // мȡӵ
	int			    minPadFileSize = -1,  // ļminPadFileSizeͽвŻͳBTʱһֿܺļʹ
								// ÿļᵥֿ飬ļһļ仯󲻻Ӱ쵽ļһļĸ¡-1롣0Сļ
								// רҵģʽbUpdateExtΪTRUEǿƶ룬minPadFileSizeСpieceSize-1ôǿƶԶʹpieceSizeΪС׼
								// Ҳ˵һֿļԶ룻Сһֿļᱻڶ
    BOOL            bUpdateExt = FALSE  //ǷڸµĵչϢDLBT_Downloader_InitializeAsUpdaterӿڡҵЧbUpdateExtһЩ⹤ֻͨ
					//ļıȽϸ£ԲʹøòòʹʱpieceSizeΪ0torrentķֿСпܲͬ¸ӡ
    );

// ָӰTracker
DLBT_API HRESULT WINAPI DLBT_Torrent_AddTracker (
    HANDLE      hTorrent,       // ӵľ
    LPCWSTR     trackerURL,     // trackerĵַhttp Trackerudp Tracker
    int         tier            // ȼ˳
    );

// ƳеTracker
DLBT_API void WINAPI DLBT_Torrent_RemoveAllTracker (HANDLE hTorrent);

// ָӿʹõhttpԴصĿͻ֧httpЭأԶӸõַ
DLBT_API void WINAPI DLBT_Torrent_AddHttpUrl (HANDLE hTorrent, LPCWSTR httpUrl);

// torrentΪļ,filePathΪ·ļ
DLBT_API HRESULT WINAPI DLBT_SaveTorrentFile (
    HANDLE      hTorrent,               // ӵľ
    LPCWSTR     filePath,               // filePathΪҪtorrentļ·һǰļڵġbUseHashNameTRUE˵ҪʹhashֵַΪtorrent
                                        // ļôfilePathͲҪļֻ·ɡ
    LPCSTR      password = NULL,        // passwordΪNULLҪӽмܣֻܺͬ򿪡һСܣpassword
                                        // "ZiP-OnLY"(ִСд)ڲܣֻǶtorrentһzipѹԼСtorrentС룬ܵͬʱҲԶzipѹġ
    BOOL        bUseHashName = FALSE,   // ǷֱʹhashֵַΨһıַΪtorrent֣ǣfilePathֻҪļ·ļ
    LPCWSTR     extName = NULL          // չbUseHashNameʹãbUseHashNameΪTRUEʱЧΪNULLڲԶʹ.torrentΪչ дչ".abc"
    );

// ͷtorrentļľ
DLBT_API void WINAPI DLBT_ReleaseTorrent (HANDLE hTorrent);


// һӾ޸Ļ߶ȡϢвҪDLBT_ReleaseTorrentͷtorrentļľ
DLBT_API HANDLE WINAPI DLBT_OpenTorrent (
    LPCWSTR     torrentFile,    // ļȫ·
    LPCSTR      password = NULL                 // ǷӣΪNullͨӣӵ,Դн
    );

DLBT_API HANDLE WINAPI DLBT_OpenTorrentFromBuffer (
    LPBYTE      torrentFile,                    // Դڴеַ
    DWORD       dwTorrentFileSize,              // ݵĴС
    LPCSTR      password = NULL                 // ǷӣΪNullͨӣӵ,Դн
    );

DLBT_API HRESULT WINAPI DLBT_Torrent_GetComment (
    HANDLE      hTorrent,       // ļ
    LPWSTR      pBuffer,        // ڷϢڴ棬ΪգΪpBufferSizeз۵ʵʴС
    int     *   pBufferSize     // ۵ڴС۵ʵʴС
    );

// شϢ
DLBT_API HRESULT WINAPI DLBT_Torrent_GetCreator (
    HANDLE      hTorrent,       // ļ
    LPWSTR      pBuffer,        // ڷϢڴ棬ΪգΪpBufferSizeзϢʵʴС
    int     *   pBufferSize     // ϢڴСϢʵʴС
    );

// طϢ
DLBT_API HRESULT WINAPI DLBT_Torrent_GetPublisher (
    HANDLE      hTorrent,       // ļ
    LPWSTR      pBuffer,        // ڷϢڴ棬ΪգΪpBufferSizeзϢʵʴС
    int     *   pBufferSize     // ϢڴСϢʵʴС
    );
// طַ
DLBT_API HRESULT WINAPI DLBT_Torrent_GetPublisherUrl (
    HANDLE      hTorrent,       // ļ
    LPWSTR      pBuffer,        // ڷϢڴ棬ΪգΪpBufferSizeзʵʴС
    int     *   pBufferSize     // ϢڴСʵʴС
    );

DLBT_API HRESULT WINAPI DLBT_Torrent_MakeURL (  // ͨӣһԲҪӼصַοDLBT_Downloader_Initialize_FromUrl
    HANDLE      hTorrent,
    LPSTR       pBuffer,                // ڷϢڴ棬ΪգΪpBufferSizeзֵʵʴС
    int  *      pBufferSize             // bufferڴСURLʵʴС
    );

DLBT_API int WINAPI DLBT_Torrent_GetTrackerCount (HANDLE hTorrent);

DLBT_API LPCSTR WINAPI DLBT_Torrent_GetTrackerUrl (
    HANDLE      hTorrent,       // ļ
    int         index           // Trackerţ0ʼ
    );

DLBT_API UINT64 WINAPI DLBT_Torrent_GetTotalFileSize (HANDLE hTorrent);

// аļʱһЩӿ,indexΪļкţ0ʼ
DLBT_API int WINAPI DLBT_Torrent_GetFileCount (HANDLE hTorrent);
DLBT_API BOOL WINAPI DLBT_Torrent_IsPadFile (HANDLE hTorrent, int index);
DLBT_API UINT64 WINAPI DLBT_Torrent_GetFileSize (
    HANDLE      hTorrent,           // ļ
    int         index               // ҪȡСļţļǴ0ʼ
    );
DLBT_API HRESULT WINAPI DLBT_Torrent_GetFilePathName (
    HANDLE      hTorrent,           // ļ
    int         index,              // ҪȡֵļţļǴ0ʼ
    LPWSTR      pBuffer,            // ļ
    int     *   pBufferSize        // bufferĴСļʵʳ
    );

DLBT_API int WINAPI DLBT_Torrent_GetPieceCount (HANDLE hTorrent);
DLBT_API int WINAPI DLBT_Torrent_GetPieceSize (HANDLE hTorrent);

// ȡÿֿHashֵ
DLBT_API HRESULT WINAPI DLBT_Torrent_GetPieceInfoHash (
    HANDLE      hTorrent,           // ļ
    int         index,              // ҪȡPieceţpieceĿͨDLBT_Torrent_GetPieceCount
    LPSTR       pBuffer,            // Hashַ
    int     *   pBufferSize         // pBufferĴСpieceInfoHash̶Ϊ20ֽڣ˴˴Ӧ20ĳȡ
    );

// ļInfoHashֵ
DLBT_API HRESULT WINAPI DLBT_Torrent_GetInfoHash (
    HANDLE      hTorrent,           // ļľ
    LPSTR       pBuffer,            // InfoHashڴ滺
    int     *   pBufferSize         // 뻺ĴСʵʵInfoHashĳ
    );

// **************************** гйصĽӿ *****************************
// гҵ汾ṩðʱṩù
struct DLBT_TM_ITEM     //геһļ
{
	DLBT_TM_ITEM(): fileSize (0) {}

	UINT64  fileSize;      // the size of this file
	char	name[256];     // 
	LPCSTR	url;           // صurl
	LPCSTR  comment;       // 
};

struct DLBT_TM_LIST //геһļ
{
	int				count;      //Ŀ
	DLBT_TM_ITEM	items[1];   //б
};

// ڱгһļ
DLBT_API HRESULT WINAPI DLBT_TM_AddSelfTorrent (LPCWSTR torrentFile, LPCSTR password = NULL);
// ڱгƳһļ
DLBT_API HRESULT WINAPI DLBT_TM_RemoveSelfTorrent (LPCWSTR torrentFile, LPCSTR password = NULL);

// ȡгебȡбҪDLBT_TM_FreeTMListͷŵ
DLBT_API HRESULT WINAPI DLBT_TM_GetSelfTorrentList (DLBT_TM_LIST ** ppList);
// ȡгебȡбҪDLBT_TM_FreeTMListͷŵ
DLBT_API HRESULT WINAPI DLBT_TM_GetRemoteTorrentList (DLBT_TM_LIST ** ppList);

// ͷDLBT_TM_GetSelfTorrentListDLBT_TM_GetRemoteTorrentListȡбڴ
DLBT_API HRESULT WINAPI DLBT_TM_FreeTMList (DLBT_TM_LIST * pList);

// лȡ˵б
DLBT_API void WINAPI DLBT_TM_ClearRemoteTorrentList ();
// Լгеб
DLBT_API void WINAPI DLBT_TM_ClearSelfTorrentList ();

// һǷгĬϲá
DLBT_API BOOL WINAPI DLBT_EnableTorrentMarket (bool bEnable);


// *********************  ǷǽUPnP͸P2PԽӿ **********************

// ˿ڵ
enum PORT_TYPE
{
    TCP_PORT        = 1,            // TCP ˿
    UDP_PORT                        // UDP ˿
};

//  ĳӦóӵICFǽȥɶںӦãںȻʹøú
DLBT_API BOOL WINAPI DLBT_AddAppToWindowsXPFirewall (
    LPCWSTR      appFilePath,        // ·exe֣
    LPCWSTR      ruleName            // ڷǽʾ
    );
// ĳ˿ڼUPnPӳ䣬BTڲж˿ѾԶ룬Ҫٴμ룬ṩǹⲿԼ˿
DLBT_API void WINAPI DLBT_AddUPnPPortMapping(
	USHORT      nExternPort,        // NATҪ򿪵ⲿ˿
	USHORT      nLocalPort,         // ӳڲ˿ڣ˿ڣһǳڼĶ˿
	PORT_TYPE   nPortType,          // ˿ͣUDPTCP
	LPCSTR      appName             // NATʾ
	);

// õϵͳĲƣ0ʾϵͳܲ޵XPϵͳ޸
// ɶںʹãںǰʹ
DLBT_API DWORD WINAPI DLBT_GetCurrentXPLimit ();

// ޸XPĲƣBOOL־Ƿɹ
DLBT_API BOOL WINAPI DLBT_ChangeXPConnectionLimit (DWORD num);



// ***************************  ȡϢĽӿ ********************************

// ں˵ĻϢ
struct KERNEL_INFO
{
    USHORT                      port;                           // ˿
    BOOL                        dhtStarted;                     // DHTǷ
    int                         totalDownloadConnectionCount;   // ܵ
    int                         downloadCount;                  // ĸ
    int                         totalDownloadSpeed;             // ٶ
    int                         totalUploadSpeed;               // ϴٶ
    UINT64                      totalDownloadedByteCount;       // صֽ
    UINT64                      totalUploadedByteCount;         // ϴֽ

    int                         peersNum;                       // ǰϵĽڵ
    int                         dhtConnectedNodeNum;            // dhtϵĻԾڵ
    int                         dhtCachedNodeNum;               // dht֪Ľڵ
    int                         dhtTorrentNum;                  // dht֪torrentļ
};

// ĻϢ
struct DOWNLOADER_INFO
{
    DLBT_DOWNLOAD_STATE          state;                         // ص״̬
    float                       percentDone;                    // ѾصݣtorrentݵĴС ֻѡһļأôýȲᵽ100%
    int                         downConnectionCount;            // ؽ
    int                         downloadLimit;                  // 
    int                         connectionCount;                // ܽϴ
    int                         totalCompletedSeeds;            // TrackerɵTracker֧scrap򷵻-1
    int                         inCompleteNum;                  // ܵδɵTracker֧scrap򷵻-1
    int                         seedConnected;                  // ϵɵ
    int                         totalCurrentSeedCount;          // ǰߵܵɵϵĺδϵģ
    int                         totalCurrentPeerCount;          // ǰߵܵصϵĺδϵģ
    float                       currentTaskProgress;            // ǰĽ 100.0%ɣ
    BOOL                        bReleasingFiles;                // ǷͷļһɺȻˣļͻڲҪһʱͷš
    UINT                        downloadSpeed;                  // صٶ
    UINT                        uploadSpeed;                    // ϴٶ
    UINT                        serverPayloadSpeed;             // ӷصЧٶȣϢȷԴ䣩
    UINT                        serverTotalSpeed;               // ӷصٶ(ϢͨѶģ

    UINT64                      wastedByteCount;                // ݵֽϢȣ
    UINT64                      totalDownloadedBytes;           // صݵֽ
    UINT64                      totalUploadedBytes;             // ϴݵֽ
    UINT64                      totalWantedBytes;               // ѡݴС
    UINT64                      totalWantedDoneBytes;           // ѡУɵݴС

    UINT64                      totalServerPayloadBytes;        // ӷصļݣҲյݣʹ -- һû⣬ᶪݵģ
    UINT64                      totalServerBytes;               // ӷصݵtotalServerPayloadBytesԼݡշϢȣ
    UINT64                      totalPayloadBytesDown;          // ܵصݿ͵˷ݣԼܶݣ
    UINT64                      totalBytesDown;                 // ܵݵ˷ԼпͻݡͨѶȣ

    // TorrentϢ
    BOOL                        bHaveTorrent;                   // ģʽжǷѾȡtorrentļ
    UINT64                      totalFileSize;                  // ļܴС
    UINT64                      totalFileSizeExcludePadding;    // ʵļĴСpaddingļ, paddingļtotalFileSize
    UINT64                      totalPaddingSize;               // paddingݵĴСʱûpaddingļΪ0
    int                         pieceCount;                     // ֿ
    int                         pieceSize;                      // ÿĴС
    char                        infoHash [256];                 // ļHashֵ
};

// ÿϵĽڵ㣨ûϢ
struct PEER_INFO_ENTRY
{
	int							connectionType;					//  0׼BT(tcp); 1: P2SPhttp 2: udpֱӻߴ͸
    int                         downloadSpeed;                  // ٶ
    int                         uploadSpeed;                    // ϴٶ
    UINT64                      downloadedBytes;                // صֽ
    UINT64                      uploadedBytes;                  // ϴֽ

    int                         uploadLimit;                    // ӵϴ٣ԷIPˣطԿIP
    int                         downloadLimit;                  // ӵ٣ԷIPˣطԿIP

    char                        ip [64];                        // ԷIP
    char                        client [64];                    // ԷʹõĿͻ

};

// ϵĽڵ㣨ûϢ
struct PEER_INFO
{
    int                         count;                          // ܵĽڵ㣨û
    PEER_INFO_ENTRY             entries [1];                    // ڵϢ
};


// ȡϢĽӿ
DLBT_API HRESULT WINAPI DLBT_GetKernelInfo (KERNEL_INFO * info);
DLBT_API HRESULT WINAPI DLBT_GetDownloaderInfo (HANDLE hDownloader, DOWNLOADER_INFO * info);

// ɽڵббDLL䣬ˣҪDLBT_FreeDownloaderPeerInfoListͷŸڴ
DLBT_API HRESULT WINAPI DLBT_GetDownloaderPeerInfoList (HANDLE hDownloader, PEER_INFO ** ppInfo);
DLBT_API void WINAPI DLBT_FreeDownloaderPeerInfoList (PEER_INFO * pInfo);

DLBT_API void WINAPI DLBT_SetDHTFilePathName (LPCWSTR dhtFile);

// ԶIOĺԽBTĶдļвⲿд滻ڲĶдȣ
// ùΪ߼湦ܣϵȡ֧֣Ĭϰ汾вŸù

// IOĽӹܽṹָ
DLBT_API void WINAPI DLBT_Set_IO_OP(void * op);
// ԽṹкȸֵĬϵĺָ
DLBT_API void WINAPI DLBT_InitDefault_IO_OP(void * op);
// ȡϵͳڲĿǰõIOָ
DLBT_API void * WINAPI DLBT_Get_IO_OP();

// ȡϵͳԭʼIOָ
DLBT_API void * WINAPI DLBT_Get_RAW_IO_OP();

#endif
