unit DLBT;

interface

uses
  windows, SysUtils;

const
   DLBT_Library = 'dlbt.dll';

//=======================================================================================
//  ʶӦЩӣTrackerءDHThttpЭصȣ
//=======================================================================================
DLBT_PROXY_TO_TRACKER       = 1;  // Trackerʹô
DLBT_PROXY_TO_DOWNLOAD      = 2;  // ʱͬûPeerʹô
DLBT_PROXY_TO_DHT           = 4;  // DHTͨѶʹôDHTʹudpͨѶҪ֧udp
DLBT_PROXY_TO_HTTP_DOWNLOAD = 8;  // HTTPʹôhttpЭʱЧTracker

// оʹô

type
  QWORD = int64;
  USHORT = word;
  int = integer;
  LPBYTE = array of Ansichar;
  handle = HWND;
  PLPSTR=^LPSTR;
  PPLPSTR=^PLPSTR;

  
  //
   DLBT_PROXY_TYPE = (
                          DLBT_PROXY_NONE,            // ʹô
                          DLBT_PROXY_SOCKS4,          // ʹSOCKS4
                          DLBT_PROXY_SOCKS5,          // ʹSOCKS5
                          DLBT_PROXY_SOCKS5A,         // ʹҪ֤SOCKS5
                          DLBT_PROXY_HTTP,            // ʹHTTP
                          DLBT_PROXY_HTTPA            // ʹҪ֤HTTP
                          );

  // ص״̬
   DLBT_DOWNLOAD_STATE = (
                            	BTDS_QUEUED,	                // 
	                            BTDS_CHECKING_FILES,	        // ڼУļ
	                            BTDS_DOWNLOADING_TORRENT,	    // ģʽ£ڻȡӵϢ
	                            BTDS_DOWNLOADING,	            // 
                              BTDS_PAUSED,                  // ͣ
	                            BTDS_FINISHED,	              // 
	                            BTDS_SEEDING,	                // 
	                            BTDS_ALLOCATING,              // Ԥ̿ռ -- Ԥռ䣬ٴƬ
                                                            // ѡйأʱѡԤ̷ʽܽ״̬
                              BTDS_ERROR                    // д̳ԭϸԭͨDLBT_Downloader_GetLastError֪
                              );

  // ļķģʽ,ʹ˵ĵ
   DLBT_FILE_ALLOCATE_TYPE = (
                                  FILE_ALLOCATE_REVERSED = 0,    // Ԥģʽ,Ԥȴļ,ÿһŵȷλ.
                                  FILE_ALLOCATE_SPARSE =1 ,      // Default mode, more effient and less disk space. http://msdn.microsoft.com/en-us/library/aa365564(VS.85).aspx
                                  FILE_ALLOCATE_COMPACT = 2      // ļСز,ÿһݰһ,ǵλ,вϵλ,ļλ÷ȷ

                                  );
  //ӵ
   DLBT_TORRENT_TYPE = (
                            USE_PUBLIC_DHT_NODE   = 0,      // ʹùDHTԴ
                            NO_USE_PUBLIC_DHT_NODE,         // ʹùDHTڵ
                            ONLY_USE_TRACKER               // ʹTrackerֹDHTûԴ˽ӣ
                            );

  // ˿ڵ
   PORT_TYPE = (
                    TCP_PORT        = 1,            // TCP ˿
                    UDP_PORT                        // UDP ˿
                    );
          
//=======================================================================================
//  üغ,Эַݾܣʵֱܴ䣬ڼBTЭͻ
//  󲿷Ӫ̵ķǰᵽ˽Э鲻ͬǣ˽ЭγԼ
//  P2P磬ͬBTͻ˼ݣ˽ЭȫBTЭˣûBTĺۼԴ͸
//  Ӫ̵ķͬ£ҪͬáαװHttpʹãĳЩЧ
//=======================================================================================
  DLBT_ENCRYPT_OPTION = (
    DLBT_ENCRYPT_NONE,                  // ֧κμܵݣܵͨѶϿ
    DLBT_ENCRYPT_COMPATIBLE,            // ģʽԼӲʹüܣ˵ļӽ룬ܵͬԷüģʽỰ
    DLBT_ENCRYPT_FULL,                  // ܣԼĬʹüܣͬʱͨͼܵ롣üģʽỰǼģʽỰ
                                        // Ĭ
    DLBT_ENCRYPT_FORCED                // ǿƼܣּ֧ͨѶͨӣܵϿ
  );

  // ܲ㼶 ܲ㼶ߣϻ˷һCPUݴ䰲ȫͻƷ
  DLBT_ENCRYPT_LEVEL = (
    DLBT_ENCRYPT_PROTOCOL,          // BTͨѶЭ  һڷֹӪ̵ֹ
    DLBT_ENCRYPT_DATA,              // ݣ ڱǿļ
    DLBT_ENCRYPT_PROTOCOL_MIX,      // ʹüЭģʽԷʹݼܣҲ֧ͬʹݼģʽͨѶ
    DLBT_ENCRYPT_ALL                // Эݾ 
  );

  DLBT_RELEASE_FLAG = (
    DLBT_RELEASE_NO_WAIT = 0,           // ĬϷʽReleaseֱͷţȴͷ
    DLBT_RELEASE_WAIT = 1,              // ȴļͷ
    DLBT_RELEASE_DELETE_STATUS = 2,     // ɾ״̬ļ
    DLBT_RELEASE_DELETE_ALL = 4         // ɾļ
    );


  DLBT_FILE_PRIORITIZE = (
                          DLBT_FILE_PRIORITY_CANCEL        =   0,
                          DLBT_FILE_PRIORITY_NORMAL,
                          DLBT_FILE_PRIORITY_ABOVE_NORMAL,
                          DLBT_FILE_PRIORITY_MAX
                          );

// ںʱĻǷDHTԼ˿ڵȣ
 PDLBT_KERNEL_START_PARAM = ^DLBT_KERNEL_START_PARAM ;
  DLBT_KERNEL_START_PARAM = record
    bStartLocalDiscovery:          BOOL;     // ǷڵԶ֣ͨDHTTrackerֻҪһҲ֣ٶȿ죬Լȷͬһˣ
    bStartUPnP:                    BOOL;     // ǷԶUPnPӳBTںĶ˿
    bStartDHT:                     BOOL;     // ĬǷDHTĬϲԺýӿ
    bLanUser:                      BOOL;     // Ƿ񴿾ûϣûӺͨѶģʽ---ռֻͨûأ
    bVODMode:                      BOOL;     // ں˵ģʽǷϸVODģʽϸVODģʽʱһļķֿϸ񰴱Ƚ˳ķʽأǰأߴмĳ϶λ
                                             // ģʽȽʺϱر߲,ģʽ˺ܶŻڲأԲʺϴصķֻڱر߲ʱʹáĬͨģʽ
                                             // VODϰ汾Ч
    startPort:                     USHORT;   // ں˼Ķ˿ڣstartPortendPortΪ0 startPort > endPort || endPort > 32765 ֲǷںһ˿ڡ startPortendPortϷ
    endPort:                       USHORT;   // ںԶstartPort ---- endPort֮һõĶ˿ڡ˿ڿԴDLBT_GetListenPort
  end;

//=======================================================================================
//  ôغ,ҵȨд˹ܣʾݲṩ
//=======================================================================================
PDLBT_PROXY_SETTING = ^DLBT_PROXY_SETTING ;
DLBT_PROXY_SETTING = record
    proxyHost: array[1..256] of Ansichar;    // ַ
    nPort:int;                          // Ķ˿
    proxyUser: array[1..256] of Ansichar;    // Ҫ֤Ĵ,û
    proxyPass: array[1..256] of Ansichar;    // Ҫ֤Ĵ,
    proxyType:DLBT_PROXY_TYPE;      // ָ
end;

  // ں˵ĻϢ
 PKERNEL_INFO = ^KERNEL_INFO ;
  KERNEL_INFO = record
    port:                          USHORT;      // ˿
    dhtStarted:                    BOOL;     // DHTǷ
    totalDownloadConnectionCount:  int;         // ܵ
    downloadCount:                 int;         // ĸ
    totalDownloadSpeed:            int;         // ٶ
    totalUploadSpeed:              int;         // ϴٶ
    totalDownloadedByteCount:      UINT64;      // صֽ
    totalUploadedByteCount:        UINT64;      // ϴֽ
    peersNum:                      int;         // ǰϵĽڵ
    dhtConnectedNodeNum:           int;         // dhtϵĻԾڵ
    dhtCachedNodeNum:              int;         // dht֪Ľڵ
    dhtTorrentNum:                 int;         // dht֪torrentļ
  end;

  // ĻϢ
  PDOWNLOADER_INFO = ^DOWNLOADER_INFO;
  DOWNLOADER_INFO = record
    state:                 DLBT_DOWNLOAD_STATE ;      // ص״̬
    percentDone:           single;                    // ѾصݣtorrentݵĴС ֻѡһļأôýȲᵽ100%
    downConnectionCount:   int;                       // ؽ
    downloadLimit:         int;                       // 
    connectionCount:       int;                       // ܽϴ
    totalCompletedSeeds:   int;                       // Tracker֧scrap򷵻-1
    inCompleteNum:         int;                       // ܵδɵTracker֧scrap򷵻-1
    seedConnected:         int;                       // ϵɵ
    totalCurrentSeedCount: Int;                       // ǰߵܵɵϵĺδϵģ
    totalCurrentPeerCount: int;                       // ǰߵܵصϵĺδϵģ
    currentTaskProgress:   single;                    // ǰĽ (100%ɣ
    bReleasingFiles:       BOOL;                      // ǷͷļһɺȻˣļͻڲҪһʱͷš
    
    downloadSpeed:         DWORD;                     // صٶ
    uploadSpeed:           DWORD;                     // ϴٶ
    serverPayloadSpeed:    DWORD;                     // ӷصЧٶȣϢȷԴ䣩
    serverTotalSpeed:      DWORD;                     // ӷصٶ(ϢͨѶģ

    wastedByteCount:       UINT64;                    // ݵֽϢȣ
    totalDownloadedBytes:  UINT64;                    // صݵֽ
    totalUploadedBytes:    UINT64;                    // ϴݵֽ
    totalWantedBytes:      UINT64;                    // ѡݴС
    totalWantedDoneBytes:  UINT64;                    // ѡУɵݴС

    totalServerPayloadBytes: UINT64;                  // ӷصļݣҲյݣʹ -- һû⣬ᶪݵģ
    totalServerBytes:      UINT64;                    // ӷصݵtotalServerPayloadBytesԼݡշϢȣ
    totalPayloadBytesDown: UINT64;                    // ܵصݿ͵˷ݣԼܶݣ
    totalBytesDown:        UINT64;                    // ܵݵ˷ԼпͻݡͨѶȣ


    // TorrentϢ
    bHaveTorrent:          BOOL;                      // ģʽжǷѾȡtorrentļ
    totalFileSize:         UINT64;                    // ļܴС
    totalFileSizeExcludePadding: UINT64;              // ʵļĴСpaddingļ, paddingļtotalFileSize
    totalPaddingSize:      UINT64;                    // paddingݵĴСʱûpaddingļΪ0
    pieceCount:            int;                       // ֿ
    pieceSize:             int;                       // ÿĴС
    infoHash:              array[1..256] of Ansichar;     // ļHashֵ
  end;

  // ÿϵĽڵ㣨ûϢ
  PPEER_INFO_ENTRY = ^PEER_INFO_ENTRY;
  PEER_INFO_ENTRY = record
    connectionType:       int;                  //   0׼BT(tcp); 1: P2SPhttp 2: udpֱӻߴ͸
    downloadSpeed:        int;                  // ٶ
    uploadSpeed:          int;                  // ϴٶ
    downloadedBytes:      UINT64;               // صֽ
    uploadedBytes:        UINT64;               // ϴֽ
    uploadLimit:          int;                  // ӵϴ٣ԷIPˣطԿIP
    downloadLimit:        int;                  // ӵ٣ԷIPˣطԿIP

    ip:                   array[0..63] of Ansichar; // ԷIP
    client:               array[0..63] of Ansichar; // ԷʹõĿͻ
  end;

  // ϵĽڵ㣨ûϢ
  PPEER_INFO = ^PEER_INFO;
  PPPEER_INFO = ^PPEER_INFO;
  PEER_INFO  = record
    count: int;                                  // ܵĽڵ㣨û
    entries: array[0..0] of PEER_INFO_ENTRY ;       // ڵϢ
  end;


// ***************************  ںصĽӿ ********************************

//=======================================================================================
//  ں˵͹رպҵȨ˽Э鹦ܣʾ͸Ѱֻñ׼BTʽ
//=======================================================================================
function DLBT_Startup(
         port: PDLBT_KERNEL_START_PARAM = nil;      // ںãοDLBT_KERNEL_START_PARAMΪnilʹڲĬ
         privateProtocolIDs: LPCSTR = nil;          // Զ˽Э飬ͻӪơΪNULLΪ׼BTͻ
                                                    // BT˽Э3.4汾нȫ¸ĽԴ͸󲿷Ӫ̶Эķ
         seedServerMode: boolean = False;           // ǷϴģʽϴģʽڲЩŻʺϴ󲢷ϴͨͻãֻϴʹ
                                                    // רҵϴģʽҵЧʾݲָ֧ùܡʹ˵ĵ
         ProductNum: LPCSTR = nil
         ): boolean; stdcall;                       // רҵϴģʽҵЧʾ͸Ѱݲָ֧ùܡʹ˵ĵ


// ں˼Ķ˿
function DLBT_GetListenPort():USHORT; stdcall;

// رյBTں
procedure DLBT_Shutdown(); stdcall;

// ڹرյٶȿܻȽ(Ҫ֪ͨTracker Stop), ԿԵøúǰ֪ͨ,ٶ
// Ȼڳ˳ʱDLBT_ShutdownȴĽ
procedure DLBT_PreShutdown(); stdcall;

//=======================================================================================
//  ں˵ϴٶȡû
//=======================================================================================
// ٶƣλֽ(BYTE)Ҫ1M 1024*1024
procedure DLBT_SetUploadSpeedLimit(limit: int); stdcall;
procedure DLBT_SetDownloadSpeedLimit(limit: int); stdcall;
// ӵ
procedure DLBT_SetMaxUploadConnection(limit: int); stdcall;
procedure DLBT_SetMaxTotalConnection(limit: int); stdcall;

// ෢İ뿪ܶӿǷˣûϣ
procedure DLBT_SetMaxHalfOpenConnection(limit: int); stdcall;

//=======================================================================================
//  þԶֵһЩ, interval_seconds鲥鲻Ҫ10s bUseBroadcast: Ƿʹù㲥ģʽ
//  Ĭڲʹ鲥ʹù㲥ܾ̫࣬һ㲻
//=======================================================================================
procedure DLBT_SetLsdSetting (interval_seconds: int; bUseBroadcast: bool); stdcall;

// P2SPʱҪչǷһԼļ·ı
//չڷֹһЩӪ̶httpڻ棬Եصǻϰ汾ļԿʹһ.phpչֹû
//Ҫý.php׺ԣļͨnginxrewriteȹʵ
//Ƿһ?a=bֲҲǷֹģǶӪ̶Ч
//bUtf8Ƿʹutf8·룬ĬtruefalseЩ·ȡ
// úΪȫֵģĳ
procedure DLBT_SetP2SPExtName (extName: LPCSTR; bUseRandParam: bool; bUtf8: bool); stdcall;

// ǷԸԼͬһû٣limitΪtrueʹúеֵ٣ޡĬϲͬһµûӦ١
procedure DLBT_SetLocalNetworkLimit(
	   Limit: bool;		 // Ƿþ
	   downSpeedLimit: int;	// þ٣ٵĴСλֽ/
	   uploadSpeedLimit:int  // þ٣ϴٶȴСλֽ/
	  ); stdcall;


// ļɨУʱϢcircleCountѭٴһϢĬ0ҲǲϢ
// sleepMsϢãĬ1ms
procedure DLBT_SetFileScanDelay (circleCount:DWORD; sleepMs:DWORD); stdcall;

// ļɺǷ޸Ϊԭʼ޸ʱ䣨ʱÿļ޸ʱ״̬øútorrentлÿļʱ޸ʱϢ
// ûʱϢҵ˸úÿļʱԶļ޸ʱΪtorrentм¼ʱ
// ֻصĻ˸úӵĻûʹøúûÿļʱϢҲ޷ʱ޸
procedure DLBT_UseServerModifyTime(bUseServerTime:BOOL); stdcall;

// ǷUDP͸书ܣĬԶӦԷ֧֣tcp޷ʱԶлΪudpͨѶ
procedure DLBT_EnableUDPTransfer(bEnabled:BOOL);stdcall;

// ǷαװHttp䣬ĳЩǡһЩ磩Http٣P2P20Kң绷£Http
//  ĬαװHttpĴ루ԽǵͨѶԼӲαװ ͻȺûԿǶãαװ
// αװҲиãЩһͨHttpʹʹIPBTУԷûкϷᱻƽɱ
// ƣαװûٶȡʵʹѡ
procedure DLBT_SetP2PTransferAsHttp (bHttpOut:bool; bAllowedIn:bool); stdcall;

// ǷʹõĴ͸ʹõ͸Эĳ˫ϵĵp2pڵ㸨
function DLBT_AddHoleServer(ip:LPCSTR; port:USHORT): BOOL; stdcall;

// ÷IPԶεöڱЩIPǷԱͳƴӷصݵϢٶȵһ̶ȿԶϿӣʡ
procedure DLBT_AddServerIP (ip:LPCSTR); stdcall;
// ȥp2spurlظ. ĿǣǷϣp2spurlڱûҪȥurl
procedure DLBT_AddBanServerUrl (ip:LPCSTR); stdcall;

// һ״̬ļڲĬȫɺ󱣴һΡԵΪԼҪʱĿÿ5ӱһΣ100ݺ󱣴һ
function DLBT_SetStatusFileSavePeriod (
    iPeriod:int;              //λ롣Ĭ0ɣ
    iPieceCount:int            //ֿĿĬ0ɣ
    ):BOOL; stdcall;


//=======================================================================================
//  ñTrackerıIPغ͹ʱԼNATĹIPȽЧϸο
//  BTʹ˵ĵ
//=======================================================================================
procedure DLBT_SetReportIP(ip: LPCSTR); stdcall;
function  DLBT_GetReportIP(): LPCSTR; stdcall;
procedure DLBT_SetUserAgent(agent: LPCSTR); stdcall;

//=======================================================================================
//  ô̻棬3.3汾Ѷ⿪ţ3.3汾ϵͳڲԶ8M棬ʹø
//  еλKҪ1MĻ棬Ҫ1024
//=======================================================================================
procedure DLBT_SetMaxCacheSize(size: DWORD); stdcall;

// һЩܲãĬ£BTΪͨ绷µϴãǧM
// Ҵã50M/s100M/sĵļٶȣҪЩԼڴ棬ҲЩ
// ý飬ѯȡ

procedure DLBT_SetPerformanceFactor(
                                    socketRecvBufferSize: int;      // ĽջĬòϵͳĬϵĻС
                                    socketSendBufferSize: int;      // ķͻĬòϵͳĬϴС
                                    maxRecvDiskQueueSize: int;      // δд꣬󣬽ͣգȴݶСڸò
                                    maxSendDiskQueueSize: int       // Сڸò߳̽Ϊ͵ݣ󣬽̶ͣȡ
                                    ); stdcall;


//=======================================================================================
//  DHTغ,portDHTĶ˿ڣudp˿ڣΪ0ʹں˼TCP˿ںż
//=======================================================================================
procedure DLBT_DHT_Start(port: USHORT = 0); stdcall;
procedure DLBT_DHT_Stop(); stdcall;
function DLBT_DHT_IsStarted(): boolean; stdcall;

//=======================================================================================
//  ôغ,ҵȨд˹ܣʾ͸Ѱݲṩ
//=======================================================================================

procedure DLBT_SetProxy(
                        proxySetting: DLBT_PROXY_SETTING;   // ãIP˿ڵ
                        proxyTo: int                          // ӦЩӣ궨ļͣDLBT_PROXY_TO_ALL
                        ); stdcall;

//=======================================================================================
//  ȡãproxyToʶһӵĴϢproxyToֻܵȡĳ
//  ĴãʹDLBT_PROXY_TO_ALLֶѡ
//=======================================================================================
procedure DLBT_GetProxySetting (proxySetting : PDLBT_PROXY_SETTING; proxyTo:int); stdcall;

//=======================================================================================
//  üغ,Эַݾܣʵֱܴ䣬ڼBTЭͻ
//  󲿷Ӫ̵ķǰᵽ˽Э鲻ͬǣ˽ЭγԼ
//  P2P磬ͬBTͻ˼ݣ˽ЭȫBTЭˣûBTĺۼԴ͸
//  Ӫ̵ķͬ£ҪͬáαװHttpʹãĳЩЧ
//=======================================================================================
procedure DLBT_SetEncryptSetting(
      encryptOption: DLBT_ENCRYPT_OPTION;           // ѡͻ߲
      encryptLevel: DLBT_ENCRYPT_LEVEL); stdcall;   // ܵĳ̶ȣݻЭܣ


// ***************************  ǵصĽӿ ********************************
//=======================================================================================
//  һļأصľԺԸвҪݾ
//=======================================================================================
function  DLBT_Downloader_Initialize(
                                    torrentFile: LPCWSTR;                                               // ļ·嵽ļ
                                    outPath: LPCWSTR;                                                   // غı·ֻĿ¼
                                    statusFile: LPCWSTR;                                          // ״̬ļ·
                                    fileAllocateType: DLBT_FILE_ALLOCATE_TYPE = FILE_ALLOCATE_SPARSE;  // ļģʽ
                                    bPaused: boolean = FALSE;                                          // Ƿ񣬴򿪾ͣ
                                    bQuickSeed: boolean = FALSE;                                       // Ƿٹ֣ҵṩ
                                    password: LPCSTR = nil;                                            // ǷӣΪNullͨӣӵ룬ð治֧֣òᱻ
                                    rootPathName: LPCWSTR = nil;                                        // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                                                                        // ԵļֱӽиΪָ
                                    bPrivateProtocol: Boolean = FALSE;					// Ƿ˽Э飨ԶԲͬӲòͬطʽ
                                    bZipTransfer:Boolean = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
                                    ):HANDLE; stdcall;

// һڴеļݣļԼ˵£ļǶ洢
function  DLBT_Downloader_Initialize_FromBuffer(
                                               torrentFile: PBYTE;                                             // ڴеļ
                                               dwTorrentFileSize: DWORD;                                        // ݵĴС
                                               outPath: LPCWSTR;                                                 // غı·ֻĿ¼
                                               statusFile: LPCWSTR;                                        // ״̬ļ·
                                               fileAllocateType: DLBT_FILE_ALLOCATE_TYPE = FILE_ALLOCATE_SPARSE;// ļģʽ
                                               bPaused: boolean = FALSE;
                                               bQuickSeed: boolean = FALSE;                                     // Ƿٹ֣ҵṩ
                                               password: LPCSTR = nil;                                          // ǷӣΪNullͨӣӵ룬ð治֧֣òᱻ
                                               rootPathName: LPCWSTR = nil;                                     // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                                                                               // ԵļֱӽиΪָ
				                               bPrivateProtocol: boolean = FALSE;		              // Ƿ˽Э飨ԶԲͬӲòͬطʽ
                                               bZipTransfer:Boolean = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
                                              ): HANDLE; stdcall;

function DLBT_Downloader_Initialize_FromTorrentHandle(
                                                  torrentHandle: HANDLE;                                            //Ӿ
                                                  outPath: LPCWSTR;                                                  //Ŀ¼
                                                  statusFile: LPCWSTR;                                         //״̬ļ·
                                                  fileAllocateType: DLBT_FILE_ALLOCATE_TYPE = FILE_ALLOCATE_SPARSE;
                                                  bPaused: BOOL = False;
                                                  bQuickSeed: BOOL = False;
                                                  rootPathName: LPCWSTR = nil;                                        // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                                                                                   // ԵļֱӽиΪָ
				                                          bPrivateProtocol: boolean = FALSE;					// Ƿ˽Э飨ԶԲͬӲòͬطʽ
                                                  bZipTransfer:Boolean = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
                                                  ): HANDLE; stdcall;

//ģʽðЧԵЩӿڣЧ
function DLBT_Downloader_Initialize_FromInfoHash (
						                                    trackerURL: LPCSTR;                                            // trackerĵַ
                                                infoHash:LPCSTR;                                                 // ļinfoHashֵ
                                                outPath: LPCWSTR;                                                  //Ŀ¼
					                                     	name:LPCWSTR = nil;                                            // ص֮ǰûа취ֵ֪ģ˿Դһʱ
						                                    statusFile: LPCWSTR = nil;                                         //״̬ļ·鴫һַԱʹÿɨ
                                                fileAllocateType: DLBT_FILE_ALLOCATE_TYPE = FILE_ALLOCATE_SPARSE;  // ļģʽ
                                                bPaused: BOOL = False;
						                                    rootPathName: LPCWSTR = nil;                                        // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                                                                                   // ԵļֱӽиΪָ
				                                        bPrivateProtocol: boolean = FALSE;					// Ƿ˽Э飨ԶԲͬӲòͬطʽ
                                                bZipTransfer:Boolean = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
						): HANDLE; stdcall;

// ģʽһӿڣֱַͨأַʽΪ DLBT://xt=urn:btih: Base32 info-hash [ &dn= Base32 ] [ &tr= Base32trackerĵַ ]  ([]Ϊѡ)
// ȫѭuTorrentĹٷBTչЭ
function DLBT_Downloader_Initialize_FromUrl (
						                                    url: LPCSTR;                                           // ַ
                                                outPath: LPCWSTR;                                                  //Ŀ¼
						                                    statusFile: LPCWSTR = nil;                                         //״̬ļ·鴫һַԱʹÿɨ
                                                fileAllocateType: DLBT_FILE_ALLOCATE_TYPE = FILE_ALLOCATE_SPARSE;  // ļģʽ
                                                bPaused: BOOL = False;
					                                     	rootPathName: LPCWSTR = nil;                                        // ڲĿ¼֣ΪNULLе֣Ϊָ֡
                                                                                                                   // ԵļֱӽиΪָ
				                                        bPrivateProtocol: boolean = FALSE;					// Ƿ˽Э飨ԶԲͬӲòͬطʽ
                                                bZipTransfer:Boolean = FALSE			// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
						                                ): HANDLE; stdcall;

// רҵļ½ӿڣļΪļļ仯ݿ顣ҵṩ
function DLBT_Downloader_InitializeAsUpdater ( 
						curTorrentFile: LPCWSTR;                   //ǰ汾ļ 
						newTorrentFile: LPCWSTR;                   //°ļ 
						curPath: LPCWSTR;                          //ǰļ· 
						statusFile: LPCWSTR = nil;                 //״̬ļ·鴫һַԱʹÿɨ
						fileAllocateType: DLBT_FILE_ALLOCATE_TYPE = FILE_ALLOCATE_SPARSE;  // ļģʽ
						bPaused: BOOL = False;
						curTorrentPassword: LPCSTR = nil;           // ǰ汾ӵ루˲Ҫ룩
						newTorrentFilePassword: LPCSTR = nil;           // ӵ
						rootPathName: LPCWSTR = nil;             // ڲĿ¼֣ΪNULLе֣Ϊָ֡
						bPrivateProtocol: boolean = FALSE;	// Ƿ˽Э飨ԶԲͬӲòͬطʽ
						fProgress:PDouble = nil;                 //ΪNULL򴫳DLBT_Downloader_GetOldTorrentProgressһһ
            bZipTransfer:Boolean = FALSE		// Ƿѹ䣬һıļأԷ֧ܵdlbtûԻѹ䣬
						): HANDLE; stdcall;

// רҵļʱӣȻֱӴӺӵĲȣ99%ζֻ1%Ҫء
function DLBT_Downloader_GetOldTorrentProgress (
						curTorrentFile: LPCWSTR;                   //ǰ汾ļ 
						newTorrentFile: LPCWSTR;                   //°ļ 
						curPath: LPCWSTR;                          //ǰļ· 
						statusFile: LPCWSTR = nil;                 //״̬ļ·鴫һַԱʹÿɨ
						curTorrentPassword: LPCSTR = nil;           // ǰ汾ӵ루˲Ҫ룩
						newTorrentFilePassword: LPCSTR = nil           // ӵ
						):Double; stdcall;


// ر֮ǰԵøúͣIO̶߳ԸĲ첽ģҪDLBT_Downloader_IsReleasingFilesȡǷͷУ
// úúֱӵ_ReleaseɶԸþٵDLBT_DwonloaderڲͣأȻͷŵļ
procedure DLBT_Downloader_ReleaseAllFiles(hDownloader: HANDLE); stdcall;
// ǷͷžĹ
function DLBT_Downloader_IsReleasingFiles(hDownloader: HANDLE): BOOL; stdcall;

// رhDownloaderǵ,Ҫɾļ,Խ2ΪTrue
function  DLBT_Downloader_Release(hDownloader: HANDLE; nFlag:DLBT_RELEASE_FLAG = DLBT_RELEASE_NO_WAIT): HRESULT; stdcall;

// һhttpĵַļĳWebhttpʱʹãwebı뷽ʽΪUTF-8ʽϵ޸
procedure DLBT_Downloader_AddHttpDownload(hDownloader: HANDLE; url: LPSTR ); stdcall;

// ƳһP2SPĵַУжϿҴӺѡбƳٽ
procedure DLBT_Downloader_RemoveHttpDownload (hDownloader: HANDLE; url: LPSTR); stdcall;

// һHttpַԽٸӣĬ1. ܺãã10ǶһHttpַԽ10ӡ
// ֮ǰѾһHttpַ˶ӣٶϿú½ʱЧ
procedure  DLBT_Downloader_SetMaxSessionPerHttp (hDownloader: HANDLE; limit: int); stdcall;

// ȡеHttpӣڴDLBT_Downloader_FreeConnectionsͷ
procedure DLBT_Downloader_GetHttpConnections(hDownloader:HANDLE; urls:PPLPSTR; urlCount:pinteger); stdcall;
// ͷDLBT_Downloader_GetHttpConnectionsڴ
procedure DLBT_Downloader_FreeConnections(urls:PLPSTR; urlCount:int); stdcall;

procedure DLBT_Downloader_AddTracker (hDownloader:HANDLE; url:LPCSTR; tier:int); stdcall;
procedure DLBT_Downloader_RemoveAllTracker (hDownloader:HANDLE); stdcall;
procedure DLBT_Downloader_AddHttpTrackerExtraParams (hDownloader:HANDLE; extraParams:LPCSTR); stdcall;

// Ƿ˳,ĬǷ˳(,һѭϡ,ַʽٶȿ),˳ڱ±߲
procedure DLBT_Downloader_SetDownloadSequence(hDownloader: HANDLE; ifSeq: boolean = FALSE); stdcall;

// ص״̬ Լ ͣͼĽӿ
function  DLBT_Downloader_GetState(hDownloader: HANDLE): DLBT_DOWNLOAD_STATE; stdcall;
function  DLBT_Downloader_IsPaused(hDownloader: HANDLE): boolean; stdcall;
procedure DLBT_Downloader_Pause(hDownloader: HANDLE); stdcall;                //ͣ
procedure DLBT_Downloader_Resume(hDownloader: HANDLE); stdcall;               //

//״̬µӿ һֻڼļ޷дʱŻˣ
//״̬ΪBTDS_ERRORͨýӿڻȡϸϢ
function DLBT_Downloader_GetLastError (
		      hDownloader:HANDLE;  // 
		      pBuffer:LPSTR;      // ڷϢڴ棬ΪգΪpBufferSizeзֵʵʴС
		      pBufferSize: pinteger // bufferڴСֵʵʴС
		   ): HRESULT; stdcall;
   
//󣬳¿ʼ
procedure DLBT_Downloader_ResumeInError (hDownloader:HANDLE); stdcall; 

// صؽӿڣģʽðЧԵЩӿڣЧ
function DLBT_Downloader_IsHaveTorrentInfo (hDownloader:HANDLE): boolean; stdcall; // ʱжǷɹȡϢ
function DLBT_Downloader_MakeURL (  // ͨӣһԲҪӼصַοDLBT_Downloader_Initialize_FromUrl
		      hDownloader:HANDLE;  // 
		      pBuffer:LPSTR;      // ڷϢڴ棬ΪգΪpBufferSizeзֵʵʴС
		      pBufferSize: pinteger // bufferڴСURLʵʴС    
		      ): HRESULT; stdcall;
// أѾصӣӱԺʹ
function DLBT_Downloader_SaveTorrentFile (hDownloader:HANDLE; filePath:LPCWSTR; password:LPCSTR = nil): HRESULT; stdcall;

// صٺӵĽӿ
procedure DLBT_Downloader_SetDownloadLimit(hDownloader: HANDLE; limit: int); stdcall;
procedure DLBT_Downloader_SetUploadLimit(hDownloader: HANDLE; limit: int); stdcall;
procedure DLBT_Downloader_SetMaxUploadConnections(hDownloader: HANDLE; limit: int); stdcall;
procedure DLBT_Downloader_SetMaxTotalConnections( limit: int); stdcall;

// ȷֻϴ
procedure DLBT_Downloader_SetOnlyUpload (hDownloader: HANDLE; bUpload:boolean); stdcall;

// öԷIP٣λBYTE(ֽڣҪ1M1024*1024
procedure DLBT_Downloader_SetServerDownloadLimit(hDownloader: HANDLE; limit: int); stdcall;
// ñȥеķIPӣڶԷӣҪBTЭ֪ͨǶӦhDownloaderĺٶϿ
procedure DLBT_Downloader_BanServerDownload(hDownloader: HANDLE; limit: int); stdcall;

// ط (ϴ/صıĽӿ
procedure DLBT_Downloader_SetShareRateLimit(hDownloader: HANDLE; fRate: single); stdcall;
function  DLBT_Downloader_GetShareRate(hDownloader: HANDLE): double; stdcall;

// صļԣļСȵȣ
function  DLBT_Downloader_GetTorrentName(
                                    hDownloader: HANDLE;
                                    pBuffer:LPCWSTR;
                                    pBufferSize:pinteger
                                    ): HRESULT; stdcall;
function  DLBT_Downloader_GetTotalFileSize(hDownloader: HANDLE): UINT64; stdcall;
function DLBT_Downloader_GetTotalWanted(hDownloader: HANDLE): Int64; stdcall;
function DLBT_Downloader_GetTotalWantedDone(hDownloader: HANDLE): Int64; stdcall;
function  DLBT_Downloader_GetProgress(hDownloader: HANDLE): single; stdcall;

function  DLBT_Downloader_GetDownloadedBytes(hDownloader: HANDLE): UINT64; stdcall;
function  DLBT_Downloader_GetUploadedBytes(hDownloader: HANDLE): UINT64; stdcall;
function  DLBT_Downloader_GetDownloadSpeed(hDownloader: HANDLE): DWORD; stdcall;
function  DLBT_Downloader_GetUploadSpeed(hDownloader: HANDLE): DWORD; stdcall;

// øĽڵĿĿĲΪintָ룬ҪĳֵNULL
procedure DLBT_Downloader_GetPeerNums(
                                      hDownloader: HANDLE;          // ľ
                                      connectedCount: pinteger;     // ϵĽڵû
                                      totalSeedCount: pinteger;     // ܵĿTracker֧scrap򷵻-1
                                      seedsConnected: pinteger;     // Լϵ
                                      inCompleteCount: pinteger;     // δTracker֧scrap򷵻-1
                                      totalCurrentSeedCount: PInteger;
                                      totalCurrentPeerCount: PInteger
                                      ); stdcall;

// аļʱһЩӿ,indexΪļкţ0ʼ
function  DLBT_Downloader_GetFileCount(hDownloader: HANDLE): int; stdcall;
function  DLBT_Downloader_GetFileSize(hDownloader: HANDLE; index: int): UINT64; stdcall;
// ȡļtorrentеʼλ
function  DLBT_Downloader_GetFileOffset(hDownloader: HANDLE; index: int): UINT64; stdcall;
function  DLBT_Downloader_IsPadFile(hDownloader: HANDLE; index: int): Boolean; stdcall;
function  DLBT_Downloader_GetFilePathName(
                                         hDownloader: HANDLE;           // ľ
                                         index: int;                    // ļ
                                         pBuffer: LPCWSTR;                // ļ
                                         pBufferSize: pinteger;         // bufferĴСļʵʳ
                                         needFullPath: boolean = false  // ǷҪȫ·ֻҪļе·
                                         ): HRESULT; stdcall;

// úὫĿ¼´ڣtorrent¼вڵļȫɾԵļЧʹá
function DLBT_Downloader_DeleteUnRelatedFiles (hDownloader: HANDLE): HRESULT; stdcall;

// ȡÿļHashֵֻʱʹbUpdateExtܻȡ
function DLBT_Downloader_GetFileHash (
           hDownloader: HANDLE;           // ľ
           index: int;                    // ҪȡļţpieceĿͨDLBT_Downloader_GetFileCount
           pBuffer: LPSTR;                // Hashַ
           pBufferSize: pinteger         // pBufferĴСpieceInfoHash̶Ϊ20ֽڣ˴˴Ӧ20ĳȡ
           ): HRESULT; stdcall;


// ȡļؽȣòҪн϶ڱҪʱʹ
function  DLBT_Downloader_GetFileProgress(hDownloader: HANDLE; index: int): single; stdcall;

//趨ļȼ
function DLBT_Downloader_SetFilePrioritize(hDownloader: HANDLE;
                                           index: Int;
                                           prioritize: DLBT_FILE_PRIORITIZE;
                                           bDoPriority: BOOL = True): HRESULT; stdcall;
procedure DLBT_Downloader_ApplyPrioritize(hDownloader: HANDLE); stdcall;

function DLBT_Downloader_GetPiecesStatus(hDownloader: handle;   // 
                                         pieceArray: PBOOL;     // ÿǷ񱾵µ
                                         arrayLength: int;      // ĳ
                                         pieceDownloaded: PINT  // ѾصķֿĿʾصķֿͼʱòȽáָֺϴλȡʱû
                                                                // 仯ԲҪػǰķֿ״̬ͼ

                                         ): HRESULT; stdcall;

function DLBT_Downloader_SetPiecePrioritize(hDownloader: HANDLE;
                                            index: Int;                           // 
                                            prioritize: DLBT_FILE_PRIORITIZE;     // ȼ
                                            bDoPriority: BOOL = True              // ǷӦãжֿҪãʱӦãһӦ
                                                                                  // ߿DLBT_Downloader_ApplyPrioritizeӦãΪÿӦһöҪPiece
                                                                                  // һ飬Ƚ鷳ӦһӦ

                                            ): HRESULT; stdcall;


//ָԴ
procedure DLBT_Downloader_AddPeerSource(hDownloader: HANDLE; ip: LPCSTR; port: WORD); stdcall;

// ÿʾļHashֵ
function DLBT_Downloader_GetInfoHash(
                                      hDownloader: HANDLE;       // ľ
                                      pBuffer: LPSTR;            // InfoHashڴ滺
                                      pBufferSize: pinteger      // 뻺ĴСʵʵInfoHashĳ
                                      ): HRESULT; stdcall;

function  DLBT_Downloader_GetPieceCount(hDownloader: HANDLE): int; stdcall;
function  DLBT_Downloader_GetPieceSize(hDownloader: HANDLE): int; stdcall;

// һ״̬ļ֪ͨڲ̺߳أ첽ܻһӳٲŻд
procedure DLBT_Downloader_SaveStatusFile (hDownloader: HANDLE); stdcall;

//bOnlyPieceStatus ǷֻһЩļֿϢڷɺ󷢸ÿͻͻͲٱȽˣֱӿ. ĬFALSEҲȫϢ
procedure DLBT_Downloader_SetStatusFileMode (hDownloader: HANDLE; bOnlyPieceStatus:BOOL); stdcall;

// 鿴״̬ļǷ
function DLBT_Downloader_IsSavingStatus (hDownloader: HANDLE): BOOL; stdcall;

// BTϵͳдͨʽݿ顣offsetΪݿļļУеƫsizeΪݿСdataΪݻ
// ɹS_OKʧΪʧԭǸÿ鲻Ҫٴδˡ VODǿЧ
function DLBT_Downloader_AddPartPieceData(hDownloader: HANDLE; offset:UINT64; size:UINT64; data:LPBYTE): HRESULT; stdcall;

// ֹһݽ VODǿЧ
function DLBT_Downloader_AddPieceData(
    hDownloader: HANDLE;
    piece:int;             //ֿ
    data:LPBYTE;           //ݱ
    bOverWrite:bool       //ѾˣǷ񸲸
    ): HRESULT; stdcall;

{
½ӿʱûз ֻڸ߼汾-VOD㲥汾רҵ汾ЧMFCʾеDLBT/DLBT.hļӿԼ
        ѿϵ߽
// ÿҪ滻һݿʱһصⲿԸصʾ滻ĽȣԼǷֹ滻൱ڣDLBT_Downloader_CancelReplace)
// FALSEϣֹTRUE
// һֿܻСļߴļβļճĵطһֿpieceIndexܻӦ˶ļƬΡص滻һļƬʱһ
typedef BOOL (WINAPI * DLBT_REPLACE_PROGRESS_CALLBACK) (
      IN void * pContext,                   // صģͨDLBT_Downloader_ReplacePieceDatapContext룩ﴫȥ洦
                                            // 磬ⲿһthisָ룬صʱָ֪ͨǶӦĸ
      IN int pieceIndex,                    //Ҫ滻λĸֿ飨ֿtorrentе
      IN int replacedPieceCount,            //Ѿ˶ٸpiece滻
      IN int totalNeedReplacePieceCount,    //ܹжٸҪ滻pieceֿ
      IN int fileIndex,                     //Ҫ滻λĸļ
      IN UINT64 offset,                     //ļУݵƫ
      IN UINT64 size,                       //ݵܴСƫ
      IN int replacedFileSliceCount,        //Ѿ˶ٸļƬε滻                                  
      IN int totalFileSliceCount            //ܹжٸҪ滻ļƬ
      );

// 滻ݿĽӿڣĳֱ滻ĿļͬλãһڣʱҪصķֿԶصһʱĿ¼ɺ滻ԭʼļ
// عԭʼļʹãֻزݵŵ㡣
// úأHRESULTصĲS_OK˵Ҫ鿴ֵ
// S_OKڲ߳滻мĽʱͨDLBT_Downloader_GetReplaceResultв鿴ʱԵãDLBT_Downloader_CancelReplaceȡ̲߳
DLBT_API HRESULT WINAPI DLBT_Downloader_ReplacePieceData(
	HANDLE			hDownloader,		//
	int   *			pieceArray,			// ҪЩֿ滻һint
	int				arrayLength,		// ֿĳ
	LPCWSTR			destFilePath,		// Ҫ滻ļļУĿ¼磺E:\Test\1.rarE:\Test\Game\˲ ȡ
	LPCWSTR			tempRootPathName = NULL,	// ʱĿ¼ʱʹrootPathNameҲҪϣԱļļУ¶ȡݿ
	LPCWSTR			destRootPathName = NULL,	// Ҫ滻ǸʹrootPathNameҲҪϣԱļļУ滻
    LPVOID          pContext = NULL,
    DLBT_REPLACE_PROGRESS_CALLBACK  callback = NULL  //սȣʱȡĻص
	);

// ReplacePieceDataһЩ״̬ͨDLBT_Downloader_GetReplaceResultв鿴
enum DLBT_REPLACE_RESULT
    DLBT_RPL_IDLE  = 0,     //δʼ滻
    DLBT_RPL_RUNNING,       //
    DLBT_RPL_SUCCESS,       //滻ɹ
    DLBT_RPL_USER_CANCELED, //滻һ룬ûȡ
    DLBT_RPL_ERROR,         //ͨhrDetailȡϸϢοDLBT_Downloader_GetReplaceResult


// ȡ滻ݵĽ
DLBT_API DLBT_REPLACE_RESULT WINAPI DLBT_Downloader_GetReplaceResult(
    HANDLE          hDownloader,        //
    HRESULT  *      hrDetail,           //гϸĳԭ
    BOOL     *      bThreadRunning      //ReplaceǷˣҲģ
    );

// мʱȡ滻ݵĲȡΪпܻ滻һ룬Щļǲģ
DLBT_API void WINAPI DLBT_Downloader_CancelReplace(HANDLE hDownloader);

//////////////////////   Moveؽӿ   /////////////
// MoveĽ
enum DOWNLOADER_MOVE_RESULT
	DLBT_MOVED	= 0,	//ƶɹ
	DLBT_MOVE_FAILED,	//ƶʧ
	DLBT_MOVING         //ƶ


//ƶĸĿ¼ͬһ̷ǼУǲͬǸƺɾԭʼļڲ첽
//ʹDLBT_Downloader_GetMoveResultȥȡ
DLBT_API void WINAPI DLBT_Downloader_Move (HANDLE hDownloader, LPCWSTR savePath);
//鿴ƶĽ
DLBT_API DOWNLOADER_MOVE_RESULT WINAPI DLBT_Downloader_GetMoveResult (
	HANDLE			hDownloader,   // ľ
	LPSTR			errorMsg,      // ڷسϢڴ棬DLBT_MOVE_FAILED״̬ﷵس顣NULL򲻷شϢ
	int				msgSize		   // ϢڴĴС
	); 

}


// ***************************  صĽӿ ********************************


// һTorrentľڴӵľ
function  DLBT_CreateTorrent(
                            pieceSize: int;                 // ļķֿС
                            filename: LPCWSTR;               // ļĿ¼Ŀ¼Ŀ¼ļһӣ
                            publisher: LPCWSTR = nil;       // Ϣ
                            publisherUrl: LPCWSTR = nil;     // ߵַ
                            comment: LPCWSTR = nil;          // ۺ
                            torrentType: DLBT_TORRENT_TYPE = USE_PUBLIC_DHT_NODE;   // ӵ
                            progress: PInteger = nil;
                            cancel: PBOOL = nil;
                            minPadFileSize: int = -1;
                            bUpdateExt: BOOL = False
                            ): HANDLE; stdcall; //ǷڸµĵչϢDLBT_Downloader_InitializeAsUpdaterӿڡҵЧ

// ָӰTracker
function  DLBT_Torrent_AddTracker(
                          hTorrent: HANDLE;        // ӵľ
                          trackerURL: LPCWSTR;      // trackerĵַhttp Trackerudp Tracker
                          tier: int                // ȼ˳
                          ): HRESULT; stdcall;

// ƳеTracker
procedure  DLBT_Torrent_RemoveAllTracker(hTorrent: HANDLE); stdcall;

// ָӿʹõhttpԴصĿͻ֧httpЭأԶӸõַ
procedure DLBT_Torrent_AddHttpUrl(hTorrent:HANDLE; httpUrl: LPCWSTR); stdcall;

// Ϊtorrentļ,filePathΪ·ļ
function  DLBT_SaveTorrentFile(hTorrent:HANDLE; filePath: LPCWSTR; password: LPSTR = nil; bUseHashName: BOOL = False; extName:LPCWSTR = nil): HRESULT; stdcall;
// ͷtorrentļľ
procedure DLBT_ReleaseTorrent(hTorrent:HANDLE); stdcall;


// ***************************  ǶȡصĽӿ ********************************
//                     ڲҪص»ڵϢ

// һӾ޸Ļ߶ȡϢвҪDLBT_ReleaseTorrentͷtorrentļľ
function  DLBT_OpenTorrent(
                           torrentFile: LPCWSTR;     // ļȫ·
                           password: LPCSTR          // ǷӣΪNullͨӣӵ,Դн
                           ): HANDLE; stdcall;

function  DLBT_OpenTorrentFromBuffer(
                           torrentFile: PByte;  //ļ
                           dwTorrentFile: DWORD;
                           password: LPCSTR): HANDLE; stdcall;

// رһļľ
//procedure DLBT_CloseTorrent(hTorrent: HANDLE); stdcall;

function DLBT_Torrent_GetComment(
                                 hTorrent: HANDLE;         // ļ
                                 pBuffer: LPCWSTR;           // ڷϢڴ棬ΪգΪpBufferSizeз۵ʵʴС
                                 pBufferSize: pinteger     // ۵ڴС۵ʵʴС
                                 ): HRESULT; stdcall;

// شϢ
function DLBT_Torrent_GetCreator(
                                 hTorrent: HANDLE;         // ļ
                                 pBuffer: LPWSTR;          // ڷϢڴ棬ΪգΪpBufferSizeзϢʵʴС
                                 pBufferSize: pinteger     // ϢڴСϢʵʴС
                                 ): HRESULT; stdcall;
 
// طϢ                                
function DLBT_Torrent_GetPublisher(
                                 hTorrent: HANDLE;         // ļ
                                 pBuffer: LPWSTR;           // ڷϢڴ棬ΪգΪpBufferSizeзϢʵʴС
                                 pBufferSize: pinteger     // ϢڴСϢʵʴС
                                 ): HRESULT; stdcall;

// طַ
function DLBT_Torrent_GetPublisherUrl (
                                 hTorrent: HANDLE;         // ļ
                                 pBuffer: LPWSTR;           // ڷϢڴ棬ΪգΪpBufferSizeзطַʵʴС
                                 pBufferSize: pinteger     // ϢڴСַʵʴС
                                 ): HRESULT; stdcall;

// ͨӣһԲҪӼصַοDLBT_Downloader_Initialize_FromUrl
function DLBT_Torrent_MakeURL (  
                                 hTorrent: HANDLE;         // ļ
                                 pBuffer: LPSTR ;          // ڷϢڴ棬ΪգΪpBufferSizeзֵʵʴС
                                 pBufferSize: pinteger     // bufferڴСURLʵʴС
                                 ): HRESULT; stdcall;

function DLBT_Torrent_GetTrackerCount(hTorrent: HANDLE): int; stdcall;

function DLBT_Torrent_GetTrackerUrl(
                                    hTorrent: HANDLE;       // ļ
                                    index:int               // Trackerţ0ʼ
                                    ): LPCSTR; stdcall;

// ȡаļܴС
function DLBT_Torrent_GetTotalFileSize (hTorrent:HANDLE) : UINT64; stdcall;

// аļʱһЩӿ,indexΪļкţ0ʼ
function  DLBT_Torrent_GetFileCount (hTorrent:HANDLE): int; stdcall;
function  DLBT_Torrent_IsPadFile (
                                   hTorrent: HANDLE;       // ļ
                                   index:int               // Trackerţ0ʼ
                                   ): BOOL; stdcall;

// аļʱһЩӿ,indexΪļкţ0ʼ
function  DLBT_Torrent_GetFileSize(
     hTorrent: HANDLE;     // ļ
     index:    int        // ҪȡСļţļǴ0ʼ
     ): UINT64; stdcall;
// ȡÿļ
function  DLBT_Torrent_GetFilePathName(
                                         hTorrent: HANDLE;           // ļ
                                         index: int;                    // ҪȡֵļţļǴ0ʼ
                                         pBuffer: LPCWSTR;               // ļ
                                         pBufferSize: pinteger         // bufferĴСļʵʳ
                                         ): HRESULT; stdcall;


// ȡֿĿ
function DLBT_Torrent_GetPieceCount (hTorrent:HANDLE): int; stdcall;
// ȡֿС
function DLBT_Torrent_GetPieceSize (hTorrent:HANDLE): int; stdcall;

// ȡÿֿHashֵ
function DLBT_Torrent_GetPieceInfoHash (
        hTorrent: HANDLE;           // ļ
        index: int;                 // ҪȡPieceţpieceĿͨDLBT_Torrent_GetPieceCount
        pBuffer: LPSTR;               // Hashַ
        pBufferSize: pinteger         // pBufferĴСpieceInfoHash̶Ϊ20ֽڣ˴˴Ӧ20ĳȡ
    ): HRESULT; stdcall;

// ļInfoHashֵ
function DLBT_Torrent_GetInfoHash (
	      hTorrent: HANDLE;         // ļ
        pBuffer: LPSTR;           // InfoHashڴ滺
        pBufferSize: pinteger     //뻺ĴСʵʵInfoHashĳ
    ): HRESULT; stdcall;

{
½ӿʱûз룬MFCʾеDLBT/DLBT.hļӿԼ
        ѿϵ߽

// **************************** гйصĽӿ *****************************
// гҵ汾ṩðʱṩù
struct DLBT_TM_ITEM     //геһļ
(
	DLBT_TM_ITEM(): fileSize (0) 
	
	UINT64  fileSize;      // the size of this file
	char	name[256];     // 
	LPCSTR	url;           // صurl
	LPCSTR  comment;       // 
);

struct DLBT_TM_LIST //геһļ
(
	int				count;      //Ŀ
	DLBT_TM_ITEM	items[1];   //б
);

// ڱгһļ
DLBT_API HRESULT WINAPI DLBT_TM_AddSelfTorrent (LPCWSTR torrentFile, LPCSTR password = NULL);
// ڱгƳһļ
DLBT_API HRESULT WINAPI DLBT_TM_RemoveSelfTorrent (LPCWSTR torrentFile, LPCSTR password = NULL);

// ȡгебȡбҪDLBT_TM_FreeTMListͷŵ
DLBT_API HRESULT WINAPI DLBT_TM_GetSelfTorrentList (DLBT_TM_LIST ** ppList);
// ȡгебȡбҪDLBT_TM_FreeTMListͷŵ
DLBT_API HRESULT WINAPI DLBT_TM_GetRemoteTorrentList (DLBT_TM_LIST ** ppList);

// ͷDLBT_TM_GetSelfTorrentListDLBT_TM_GetRemoteTorrentListȡбڴ
DLBT_API HRESULT WINAPI DLBT_TM_FreeTMList (DLBT_TM_LIST * pList);

// лȡ˵б
DLBT_API void WINAPI DLBT_TM_ClearRemoteTorrentList ();
// Լгеб
DLBT_API void WINAPI DLBT_TM_ClearSelfTorrentList ();

// һǷгĬϲá
DLBT_API BOOL WINAPI DLBT_EnableTorrentMarket (bool bEnable);

}

// *********************  ǷǽUPnP͸P2PԽӿ **********************


//  ĳӦóӵICFǽȥɶںӦãںȻʹøú
function  DLBT_AddAppToWindowsXPFirewall(
                                         appFilePath: LPCWSTR;        // ·exe֣
                                         ruleName: LPCWSTR            // ڷǽʾ
                                         ): boolean; stdcall;
// ĳ˿ڼUPnPӳ䣬BTڲж˿ѾԶ룬Ҫٴμ룬ṩǹⲿԼ˿
procedure DLBT_AddUPnPPortMapping(
	nExternPort: USHORT;        // NATҪ򿪵ⲿ˿
	nLocalPort: USHORT;        // ӳڲ˿ڣ˿ڣһǳڼĶ˿
	nPortType: PORT_TYPE;          // ˿ͣUDPTCP
        appName: LPCSTR             // NATʾ
	); stdcall;

// õϵͳĲƣ0ʾϵͳܲ޵XPϵͳ޸
// ɶںʹãںǰʹ
function  DLBT_GetCurrentXPLimit(): DWORD; stdcall;

// ޸XPĲƣBOOL־Ƿɹ
function  DLBT_ChangeXPConnectionLimit(num: DWORD): boolean; stdcall;

// ȡϢĽӿ
function  DLBT_GetKernelInfo(info: PKERNEL_INFO): HRESULT; stdcall;
function  DLBT_GetDownloaderInfo(hDownloader: HANDLE; info: PDOWNLOADER_INFO): HRESULT; stdcall;

// ɽڵббDLL䣬ˣҪDLBT_FreeDownloaderPeerInfoListͷŸڴ
function  DLBT_GetDownloaderPeerInfoList(hDownloader: HANDLE; ppinfo: PPEER_INFO): HRESULT; stdcall;
procedure DLBT_FreeDownloaderPeerInfoList(pinfo: PPEER_INFO); stdcall;
procedure DLBT_SetDHTFilePathName(dhtFile: LPCWSTR); stdcall;

// ԶIOĺԽBTĶдļвⲿд滻ڲĶдȣ
// ùΪ߼湦ܣϵȡ֧֣Ĭϰ汾вŸù

// IOĽӹܽṹָ
procedure DLBT_Set_IO_OP(op: Pointer); stdcall;
// ԽṹкȸֵĬϵĺָ
procedure DLBT_InitDefault_IO_OP(op: Pointer); stdcall;
// ȡϵͳڲĿǰõIOָ
function DLBT_Get_IO_OP():Pointer; stdcall;

// ȡϵͳԭʼIOָ
function DLBT_Get_RAW_IO_OP():Pointer; stdcall;


implementation

  function  DLBT_Startup; stdcall; external DLBT_Library name 'DLBT_Startup';
  function  DLBT_GetListenPort; stdcall; external DLBT_Library name 'DLBT_GetListenPort';
  procedure DLBT_Shutdown; stdcall; external DLBT_Library name 'DLBT_Shutdown';
  procedure DLBT_PreShutdown; stdcall; external DLBT_Library name 'DLBT_PreShutdown';
  procedure DLBT_SetUploadSpeedLimit; stdcall; external DLBT_Library name 'DLBT_SetUploadSpeedLimit';
  procedure DLBT_SetDownloadSpeedLimit; stdcall; external DLBT_Library name 'DLBT_SetDownloadSpeedLimit';
  procedure DLBT_SetMaxUploadConnection; stdcall; external DLBT_Library name 'DLBT_SetMaxUploadConnection';
  procedure DLBT_SetMaxTotalConnection; stdcall; external DLBT_Library name 'DLBT_SetMaxTotalConnection';
  procedure DLBT_SetMaxHalfOpenConnection; stdcall; external DLBT_Library name 'DLBT_SetMaxHalfOpenConnection';
  procedure DLBT_SetLsdSetting; stdcall; external DLBT_Library name 'DLBT_SetLsdSetting';
  procedure DLBT_SetP2SPExtName; stdcall; external DLBT_Library name 'DLBT_SetP2SPExtName';
  procedure DLBT_SetLocalNetworkLimit; stdcall; external DLBT_Library name 'DLBT_SetLocalNetworkLimit';
  procedure DLBT_SetFileScanDelay; stdcall; external DLBT_Library name 'DLBT_SetFileScanDelay';
  procedure DLBT_UseServerModifyTime; stdcall; external DLBT_Library name 'DLBT_UseServerModifyTime';
  procedure DLBT_EnableUDPTransfer; stdcall; external DLBT_Library name 'DLBT_EnableUDPTransfer'; 
  procedure DLBT_SetP2PTransferAsHttp; stdcall; external DLBT_Library name 'DLBT_SetP2PTransferAsHttp';
  function DLBT_AddHoleServer; stdcall; external DLBT_Library name 'DLBT_AddHoleServer'; 
  procedure DLBT_AddServerIP; stdcall; external DLBT_Library name 'DLBT_AddServerIP';
  procedure DLBT_AddBanServerUrl; stdcall; external DLBT_Library name 'DLBT_AddBanServerUrl';
  function DLBT_SetStatusFileSavePeriod; stdcall; external DLBT_Library name 'DLBT_SetStatusFileSavePeriod';
  procedure DLBT_SetReportIP; stdcall; external DLBT_Library name 'DLBT_SetReportIP';
  function  DLBT_GetReportIP; stdcall; external DLBT_Library name 'DLBT_GetReportIP';
  procedure DLBT_SetUserAgent; stdcall; external DLBT_Library name 'DLBT_SetUserAgent';
  procedure DLBT_SetMaxCacheSize; stdcall; external DLBT_Library name 'DLBT_SetMaxCacheSize';
  procedure DLBT_SetPerformanceFactor; stdcall; external DLBT_Library name 'DLBT_SetPerformanceFactor';
  procedure DLBT_DHT_Start; stdcall; external DLBT_Library name 'DLBT_DHT_Start';
  procedure DLBT_DHT_Stop; stdcall; external DLBT_Library name 'DLBT_DHT_Stop';
  function  DLBT_DHT_IsStarted; stdcall; external DLBT_Library name 'DLBT_DHT_IsStarted';
  procedure DLBT_SetProxy; stdcall; external DLBT_Library name 'DLBT_SetProxy';
  procedure DLBT_GetProxySetting; stdcall; external DLBT_Library name 'DLBT_GetProxySetting';
  procedure DLBT_SetEncryptSetting; stdcall; external DLBT_Library name 'DLBT_SetEncryptSetting';

  function  DLBT_Downloader_Initialize; stdcall; external DLBT_Library name 'DLBT_Downloader_Initialize';
  function  DLBT_Downloader_Initialize_FromBuffer; stdcall; external DLBT_Library name 'DLBT_Downloader_Initialize_FromBuffer';
  function DLBT_Downloader_Initialize_FromTorrentHandle; stdcall external DLBT_Library name 'DLBT_Downloader_Initialize_FromTorrentHandle';
  function DLBT_Downloader_Initialize_FromInfoHash; stdcall external DLBT_Library name 'DLBT_Downloader_Initialize_FromInfoHash';
  function DLBT_Downloader_Initialize_FromUrl; stdcall external DLBT_Library name 'DLBT_Downloader_Initialize_FromUrl';
  function DLBT_Downloader_InitializeAsUpdater; stdcall external DLBT_Library name 'DLBT_Downloader_InitializeAsUpdater';
  function DLBT_Downloader_GetOldTorrentProgress; stdcall external DLBT_Library name 'DLBT_Downloader_GetOldTorrentProgress';  
  procedure DLBT_Downloader_ReleaseAllFiles; stdcall; external DLBT_Library name 'DLBT_Downloader_ReleaseAllFiles';
  function DLBT_Downloader_IsReleasingFiles; stdcall; external DLBT_Library name 'DLBT_Downloader_IsReleasingFiles';
  function  DLBT_Downloader_Release; stdcall; external DLBT_Library name 'DLBT_Downloader_Release';

  procedure DLBT_Downloader_AddHttpDownload; stdcall; external DLBT_Library name 'DLBT_Downloader_AddHttpDownload';
  procedure DLBT_Downloader_RemoveHttpDownload; stdcall; external DLBT_Library name 'DLBT_Downloader_RemoveHttpDownload';
  procedure DLBT_Downloader_SetMaxSessionPerHttp; stdcall; external DLBT_Library name 'DLBT_Downloader_SetMaxSessionPerHttp';
  procedure DLBT_Downloader_GetHttpConnections; stdcall; external DLBT_Library name 'DLBT_Downloader_GetHttpConnections';
  procedure DLBT_Downloader_FreeConnections; stdcall; external DLBT_Library name 'DLBT_Downloader_FreeConnections';
  procedure DLBT_Downloader_AddTracker; stdcall; external DLBT_Library name 'DLBT_Downloader_AddTracker';
  procedure DLBT_Downloader_RemoveAllTracker; stdcall; external DLBT_Library name 'DLBT_Downloader_RemoveAllTracker';
  procedure DLBT_Downloader_AddHttpTrackerExtraParams; stdcall; external DLBT_Library name 'DLBT_Downloader_AddHttpTrackerExtraParams';
  procedure DLBT_Downloader_SetDownloadSequence; stdcall; external DLBT_Library name 'DLBT_Downloader_SetDownloadSequence';
  function  DLBT_Downloader_GetState; stdcall; external DLBT_Library name 'DLBT_Downloader_GetState';
  function  DLBT_Downloader_IsPaused; stdcall; external DLBT_Library name 'DLBT_Downloader_IsPaused';
  procedure DLBT_Downloader_Pause; stdcall; external DLBT_Library name 'DLBT_Downloader_Pause';
  procedure DLBT_Downloader_Resume; stdcall; external DLBT_Library name 'DLBT_Downloader_Resume';
  function  DLBT_Downloader_GetLastError; stdcall; external DLBT_Library name 'DLBT_Downloader_GetLastError';
  procedure DLBT_Downloader_ResumeInError; stdcall; external DLBT_Library name 'DLBT_Downloader_ResumeInError';
  function  DLBT_Downloader_IsHaveTorrentInfo; stdcall; external DLBT_Library name 'DLBT_Downloader_IsHaveTorrentInfo';
  function  DLBT_Downloader_MakeURL; stdcall; external DLBT_Library name 'DLBT_Downloader_MakeURL';
  function  DLBT_Downloader_SaveTorrentFile; stdcall; external DLBT_Library name 'DLBT_Downloader_SaveTorrentFile';
  procedure DLBT_Downloader_SetDownloadLimit; stdcall; external DLBT_Library name 'DLBT_Downloader_SetDownloadLimit';
  procedure DLBT_Downloader_SetUploadLimit; stdcall; external DLBT_Library name 'DLBT_Downloader_SetUploadLimit';
  procedure DLBT_Downloader_SetMaxUploadConnections; stdcall; external DLBT_Library name 'DLBT_Downloader_SetMaxUploadConnections';
  procedure DLBT_Downloader_SetMaxTotalConnections; stdcall; external DLBT_Library name 'DLBT_Downloader_SetMaxTotalConnections';
  procedure DLBT_Downloader_SetOnlyUpload; stdcall; external DLBT_Library name 'DLBT_Downloader_SetOnlyUpload';  
  procedure DLBT_Downloader_SetServerDownloadLimit; stdcall; external DLBT_Library name 'DLBT_Downloader_SetServerDownloadLimit';
  procedure DLBT_Downloader_BanServerDownload; stdcall; external DLBT_Library name 'DLBT_Downloader_BanServerDownload';
  procedure DLBT_Downloader_SetShareRateLimit; stdcall; external DLBT_Library name 'DLBT_Downloader_SetShareRateLimit';
  function  DLBT_Downloader_GetShareRate; stdcall; external DLBT_Library name 'DLBT_Downloader_GetShareRate';
  function  DLBT_Downloader_GetTorrentName; stdcall; external DLBT_Library name 'DLBT_Downloader_GetTorrentName';
  function  DLBT_Downloader_GetTotalFileSize; stdcall; external DLBT_Library name 'DLBT_Downloader_GetTotalFileSize';  
  function DLBT_Downloader_GetTotalWanted; stdcall; external DLBT_Library name 'DLBT_Downloader_GetTotalWanted';
  function DLBT_Downloader_GetTotalWantedDone; stdcall; external DLBT_Library name 'DLBT_Downloader_GetTotalWantedDone';
  function  DLBT_Downloader_GetProgress; stdcall; external DLBT_Library name 'DLBT_Downloader_GetProgress';
  function  DLBT_Downloader_GetDownloadedBytes; stdcall; external DLBT_Library name 'DLBT_Downloader_GetDownloadedBytes';
  function  DLBT_Downloader_GetUploadedBytes; stdcall; external DLBT_Library name 'DLBT_Downloader_GetUploadedBytes';
  function  DLBT_Downloader_GetDownloadSpeed; stdcall; external DLBT_Library name 'DLBT_Downloader_GetDownloadSpeed';
  function  DLBT_Downloader_GetUploadSpeed; stdcall; external DLBT_Library name 'DLBT_Downloader_GetUploadSpeed';
  procedure DLBT_Downloader_GetPeerNums; stdcall; external DLBT_Library name 'DLBT_Downloader_GetPeerNums';
  function  DLBT_Downloader_GetFileCount; stdcall; external DLBT_Library name 'DLBT_Downloader_GetFileCount';
  function  DLBT_Downloader_GetFileSize; stdcall; external DLBT_Library name 'DLBT_Downloader_GetFileSize';
  function  DLBT_Downloader_GetFileOffset; stdcall; external DLBT_Library name 'DLBT_Downloader_GetFileOffset';
  function  DLBT_Downloader_IsPadFile; stdcall; external DLBT_Library name 'DLBT_Downloader_IsPadFile';
  function  DLBT_Downloader_GetFilePathName; stdcall; external DLBT_Library name 'DLBT_Downloader_GetFilePathName';
  function DLBT_Downloader_DeleteUnRelatedFiles; stdcall; external DLBT_Library name 'DLBT_Downloader_DeleteUnRelatedFiles';
  function DLBT_Downloader_GetFileHash; stdcall; external DLBT_Library name 'DLBT_Downloader_GetFileHash';
  function  DLBT_Downloader_GetFileProgress; stdcall; external DLBT_Library name 'DLBT_Downloader_GetFileProgress';
  function DLBT_Downloader_SetFilePrioritize; stdcall; external DLBT_Library name 'DLBT_Downloader_SetFilePrioritize';
  procedure DLBT_Downloader_ApplyPrioritize; stdcall; external DLBT_Library name 'DLBT_Downloader_ApplyPrioritize';
  function DLBT_Downloader_GetPiecesStatus; stdcall; external DLBT_Library name 'DLBT_Downloader_GetPiecesStatus';
  function DLBT_Downloader_SetPiecePrioritize; stdcall; external DLBT_Library name 'DLBT_Downloader_SetPiecePrioritize';
  procedure DLBT_Downloader_AddPeerSource; stdcall; external DLBT_Library name 'DLBT_Downloader_AddPeerSource';
  function  DLBT_Downloader_GetInfoHash; stdcall; external DLBT_Library name 'DLBT_Downloader_GetInfoHash';
  function  DLBT_Downloader_GetPieceCount; stdcall; external DLBT_Library name 'DLBT_Downloader_GetPieceCount';
  function  DLBT_Downloader_GetPieceSize; stdcall; external DLBT_Library name 'DLBT_Downloader_GetPieceSize';
  procedure DLBT_Downloader_SaveStatusFile; stdcall; external DLBT_Library name 'DLBT_Downloader_SaveStatusFile';
  procedure DLBT_Downloader_SetStatusFileMode; stdcall; external DLBT_Library name 'DLBT_Downloader_SetStatusFileMode';
  function DLBT_Downloader_IsSavingStatus; stdcall; external DLBT_Library name 'DLBT_Downloader_IsSavingStatus';
  function DLBT_Downloader_AddPartPieceData; stdcall; external DLBT_Library name 'DLBT_Downloader_AddPartPieceData';
  function DLBT_Downloader_AddPieceData; stdcall; external DLBT_Library name 'DLBT_Downloader_AddPieceData';

  function  DLBT_CreateTorrent; stdcall; external DLBT_Library name 'DLBT_CreateTorrent';
  function  DLBT_Torrent_AddTracker; stdcall; external DLBT_Library name 'DLBT_Torrent_AddTracker';
  procedure DLBT_Torrent_RemoveAllTracker; stdcall; external DLBT_Library name 'DLBT_Torrent_RemoveAllTracker';
  procedure DLBT_Torrent_AddHttpUrl; stdcall; external DLBT_Library name 'DLBT_Torrent_AddHttpUrl';
  function  DLBT_SaveTorrentFile; stdcall; external DLBT_Library name 'DLBT_SaveTorrentFile';
  procedure DLBT_ReleaseTorrent; stdcall; external DLBT_Library name 'DLBT_ReleaseTorrent';

  function  DLBT_OpenTorrent; stdcall; external DLBT_Library name 'DLBT_OpenTorrent';
  function  DLBT_OpenTorrentFromBuffer; stdcall; external DLBT_Library name 'DLBT_OpenTorrentFromBuffer';
  function  DLBT_Torrent_GetComment; stdcall; external DLBT_Library name 'DLBT_Torrent_GetComment';
  function  DLBT_Torrent_GetCreator; stdcall; external DLBT_Library name 'DLBT_Torrent_GetCreator';
  function  DLBT_Torrent_GetPublisher; stdcall; external DLBT_Library name 'DLBT_Torrent_GetPublisher';
  function  DLBT_Torrent_GetPublisherUrl; stdcall; external DLBT_Library name 'DLBT_Torrent_GetPublisherUrl';
  function  DLBT_Torrent_MakeURL; stdcall; external DLBT_Library name 'DLBT_Torrent_MakeURL';
  function  DLBT_Torrent_GetTrackerCount; stdcall; external DLBT_Library name 'DLBT_Torrent_GetTrackerCount';
  function  DLBT_Torrent_GetTrackerUrl; stdcall; external DLBT_Library name 'DLBT_Torrent_GetTrackerUrl';
  function  DLBT_Torrent_GetTotalFileSize; stdcall; external DLBT_Library name 'DLBT_Torrent_GetTotalFileSize';
  function  DLBT_Torrent_GetFileCount; stdcall; external DLBT_Library name 'DLBT_Torrent_GetFileCount';
  function  DLBT_Torrent_IsPadFile; stdcall; external DLBT_Library name 'DLBT_Torrent_IsPadFile';
  function  DLBT_Torrent_GetFileSize; stdcall; external DLBT_Library name 'DLBT_Torrent_GetFileSize';
  function  DLBT_Torrent_GetFilePathName; stdcall; external DLBT_Library name 'DLBT_Torrent_GetFilePathName';
  function  DLBT_Torrent_GetPieceCount; stdcall; external DLBT_Library name 'DLBT_Torrent_GetPieceCount';
  function  DLBT_Torrent_GetPieceSize; stdcall; external DLBT_Library name 'DLBT_Torrent_GetPieceSize';
  function  DLBT_Torrent_GetPieceInfoHash; stdcall; external DLBT_Library name 'DLBT_Torrent_GetPieceInfoHash';
  function  DLBT_Torrent_GetInfoHash; stdcall; external DLBT_Library name 'DLBT_Torrent_GetInfoHash';

  function  DLBT_AddAppToWindowsXPFirewall; stdcall; external DLBT_Library name 'DLBT_AddAppToWindowsXPFirewall';
  procedure DLBT_AddUPnPPortMapping; stdcall; external DLBT_Library name 'DLBT_AddUPnPPortMapping';
  function  DLBT_GetCurrentXPLimit; stdcall; external DLBT_Library name 'DLBT_GetCurrentXPLimit';
  function  DLBT_ChangeXPConnectionLimit; stdcall; external DLBT_Library name 'DLBT_ChangeXPConnectionLimit';
  function  DLBT_GetKernelInfo; stdcall; external DLBT_Library name 'DLBT_GetKernelInfo';
  function  DLBT_GetDownloaderInfo; stdcall; external DLBT_Library name 'DLBT_GetDownloaderInfo';
  function  DLBT_GetDownloaderPeerInfoList; stdcall; external DLBT_Library name 'DLBT_GetDownloaderPeerInfoList';
  procedure DLBT_FreeDownloaderPeerInfoList; stdcall; external DLBT_Library name 'DLBT_FreeDownloaderPeerInfoList';

  procedure  DLBT_SetDHTFilePathName; stdcall; external DLBT_Library name 'DLBT_SetDHTFilePathName';

  procedure  DLBT_Set_IO_OP; stdcall; external DLBT_Library name 'DLBT_Set_IO_OP';
  procedure  DLBT_InitDefault_IO_OP; stdcall; external DLBT_Library name 'DLBT_InitDefault_IO_OP';
  function   DLBT_Get_IO_OP; stdcall; external DLBT_Library name 'DLBT_Get_IO_OP';
  function   DLBT_Get_RAW_IO_OP; stdcall; external DLBT_Library name 'DLBT_Get_RAW_IO_OP';

  
end.